/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

public abstract class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected StringUtil() {
    }

    public static String extractBack(String s, char delim) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        int l = s.length();
        int start = 0;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c != delim) continue;
            start = i + 1;
        }
        if (start == l) {
            return "";
        }
        return s.substring(start, l);
    }

    public static StringBuilder start(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getSimpleName());
        sb.append('[');
        return sb;
    }

    public static String end(StringBuilder sb) {
        return sb.append(']').toString();
    }

    public static void firstObj(StringBuilder sb, String name, Object obj) {
        sb.append(name);
        sb.append('=');
        sb.append(obj);
    }

    public static void firstObj(StringBuilder sb, Object obj) {
        sb.append(obj);
    }

    public static void addObj(StringBuilder sb, String name, Object obj) {
        sb.append(", ");
        StringUtil.firstObj(sb, name, obj);
    }

    public static void addObj(StringBuilder sb, Object obj) {
        sb.append(", ");
        sb.append(obj);
    }

    public static void firstInt(StringBuilder sb, String name, int v) {
        sb.append(name);
        sb.append('=');
        sb.append(v);
    }

    public static void addInt(StringBuilder sb, String name, int v) {
        sb.append(", ");
        StringUtil.firstInt(sb, name, v);
    }

    public static void addInt(StringBuilder sb, int v) {
        sb.append(", ");
        sb.append(v);
    }

    public static void firstLong(StringBuilder sb, String name, long v) {
        sb.append(name);
        sb.append('=');
        sb.append(v);
    }

    public static void addLong(StringBuilder sb, String name, long v) {
        sb.append(", ");
        StringUtil.firstLong(sb, name, v);
    }

    public static void addLong(StringBuilder sb, long v) {
        sb.append(", ");
        sb.append(v);
    }

    public static int count(String str, int value) {
        int off;
        if (str == null || str.length() == 0) {
            return 0;
        }
        int n = 0;
        int fromIdx = 0;
        while ((off = str.indexOf(value, fromIdx)) != -1) {
            fromIdx = off + 1;
            ++n;
        }
        return n;
    }

    public static String[] split(String str, int delimimiter) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int n = StringUtil.count(str, delimimiter);
        if (n == 0) {
            return new String[]{str};
        }
        String[] parts = new String[n + 1];
        int i = 0;
        int fromIdx = 0;
        while (true) {
            int off;
            int partLen;
            if ((partLen = (off = str.indexOf(delimimiter, fromIdx)) == -1 ? len - fromIdx : off - fromIdx) > 0) {
                parts[i++] = str.substring(fromIdx, fromIdx + partLen);
            }
            if (off == -1) break;
            fromIdx = off + 1;
        }
        if (i == parts.length) {
            return parts;
        }
        String[] rv = new String[i];
        System.arraycopy(parts, 0, rv, 0, i);
        return rv;
    }
}

