/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.manager;

import ch.bind.philib.lang.ArrayUtil;
import ch.bind.philib.pool.manager.ObjectManager;

public final class ByteArrayManager
implements ObjectManager<byte[]> {
    private final int bufferSize;

    public ByteArrayManager(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public byte[] create() {
        return new byte[this.bufferSize];
    }

    @Override
    public boolean prepareForRecycle(byte[] buf) {
        if (buf.length == this.bufferSize) {
            ArrayUtil.memclr(buf);
            return true;
        }
        return false;
    }

    @Override
    public void release(byte[] buf) {
    }

    @Override
    public boolean canReuse(byte[] buf) {
        return true;
    }
}

