/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.math.Calc;
import ch.bind.philib.validation.Validation;

public final class LeakyBucket {
    private final long capacity;
    private final long takeIntervalNs;
    private long lastRecalcNs;
    private long content;

    private LeakyBucket(long takeIntervalNs, long capacity) {
        this.takeIntervalNs = takeIntervalNs;
        this.capacity = capacity;
        this.content = capacity;
    }

    public static LeakyBucket withTakesPerSecond(double takesPerSecond, long capacity) {
        Validation.isTrue(takesPerSecond >= 1.0E-6, "takesPerSecond must be >= 0.000001");
        long takeIntervalNs = (long)Math.ceil(1.0E9 / takesPerSecond);
        return LeakyBucket.withTakeIntervalNs(takeIntervalNs, capacity);
    }

    public static LeakyBucket withTakeIntervalMs(long takeIntervalMs, long capacity) {
        return LeakyBucket.withTakeIntervalNs(takeIntervalMs * 1000000L, capacity);
    }

    public static LeakyBucket withTakeIntervalUs(long takeIntervalUs, long capacity) {
        return LeakyBucket.withTakeIntervalNs(takeIntervalUs * 1000L, capacity);
    }

    public static LeakyBucket withTakeIntervalNs(long takeIntervalNs, long capacity) {
        Validation.isTrue(takeIntervalNs > 0L, "takeIntervalNs must be > 0");
        Validation.isTrue(capacity >= 1L, "capacity must be >= 1");
        return new LeakyBucket(takeIntervalNs, capacity);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void take(long amount) {
        this.take(amount, System.nanoTime());
    }

    public void take(long amount, long timeNs) {
        this.recalculate(timeNs);
        this.content = Math.max(0L, this.content - amount);
    }

    public long canTake() {
        return this.canTake(System.nanoTime());
    }

    public long canTake(long timeNs) {
        this.recalculate(timeNs);
        return this.content;
    }

    public long nextTakeNs() {
        return this.nextTakeNs(System.nanoTime());
    }

    public long nextTakeNs(long timeNs) {
        this.recalculate(timeNs);
        if (this.content > 0L) {
            return 0L;
        }
        long nextTakeNano = this.lastRecalcNs + this.takeIntervalNs;
        return nextTakeNano - timeNs;
    }

    public long nextTakeUs() {
        return Calc.ceilDiv(this.nextTakeNs(), 1000L);
    }

    public long nextTakeMs() {
        return Calc.ceilDiv(this.nextTakeNs(), 1000000L);
    }

    public void sleepUntilAvailable() throws InterruptedException {
        long nextTakeNano;
        while ((nextTakeNano = this.nextTakeNs()) > 0L) {
            long sleepMs = nextTakeNano / 1000000L;
            int sleepNano = (int)(nextTakeNano % 1000000L);
            Thread.sleep(sleepMs, sleepNano);
        }
    }

    private void recalculate(long timeNs) {
        if (timeNs < this.lastRecalcNs) {
            this.lastRecalcNs = timeNs;
        } else {
            long diff = timeNs - this.lastRecalcNs;
            long newlyAvailable = diff / this.takeIntervalNs;
            if (newlyAvailable > 0L) {
                long newContent = this.content + newlyAvailable;
                if (newContent > this.capacity) {
                    this.content = this.capacity;
                    this.lastRecalcNs = timeNs;
                } else {
                    this.lastRecalcNs += newlyAvailable * this.takeIntervalNs;
                    this.content = newContent;
                }
            }
        }
    }
}

