/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.conf;

import ch.bind.philib.conf.ConfigListener;
import ch.bind.philib.io.SafeCloseUtil;
import ch.bind.philib.lang.CompareUtil;
import ch.bind.philib.util.CowSet;
import ch.bind.philib.validation.Validation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class Config {
    private final CowSet<ConfigListener> listeners = new CowSet<ConfigListener>(ConfigListener.class);
    private final List<URL> urls = new LinkedList<URL>();
    private boolean loading;
    private volatile Map<String, String> config;

    public Config(URL url) {
        this.setURL(url);
    }

    public Config(URL[] urls) {
        this.setURLs(urls);
    }

    public Config(Collection<URL> urls) {
        this.setURLs(urls);
    }

    public Config(Map<String, String> config) {
        this.config = new HashMap<String, String>(config);
    }

    public synchronized void setURL(URL url) {
        Validation.notNull(url);
        this.urls.clear();
        this.urls.add(url);
    }

    public synchronized void setURLs(URL[] urls) {
        Validation.notNullOrEmpty(urls);
        this.urls.clear();
        Collections.addAll(this.urls, urls);
    }

    public synchronized void setURLs(Collection<URL> urls) {
        Validation.notNullOrEmpty(urls);
        this.urls.clear();
        for (URL url : urls) {
            this.urls.add(url);
        }
    }

    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        if (this.loading || this.urls.isEmpty()) {
            return;
        }
        this.loading = true;
        int numSuccess = 0;
        IOException lastExc = null;
        HashMap<String, String> newConfig = new HashMap<String, String>();
        try {
            for (URL url : this.urls) {
                if (url == null) continue;
                InputStream is = null;
                try {
                    is = url.openStream();
                    Properties props = new Properties();
                    props.load(is);
                    Map<String, String> m = Config.toMap(props);
                    newConfig.putAll(m);
                    ++numSuccess;
                }
                catch (IOException e) {
                    lastExc = e;
                }
                finally {
                    SafeCloseUtil.close(is);
                }
            }
            if (numSuccess < 1) {
                throw new IOException("no resources found", lastExc);
            }
            if (this.config != null) {
                this.notifyDifferences(newConfig, this.config);
            } else {
                this.notifyAdded(newConfig);
            }
            this.config = newConfig;
        }
        finally {
            this.loading = false;
        }
    }

    public static Map<String, String> toMap(Properties p) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String key : p.stringPropertyNames()) {
            m.put(key, p.getProperty(key));
        }
        return m;
    }

    private void notifyDifferences(Map<String, String> newConfig, Map<String, String> oldConfig) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Set<String> newKeys = newConfig.keySet();
        Set<String> oldKeys = oldConfig.keySet();
        for (String newKey : newKeys) {
            if (oldKeys.contains(newKey)) {
                String valOld;
                String valNew = newConfig.get(newKey);
                if (CompareUtil.equals(valNew, valOld = oldConfig.get(newKey))) continue;
                this.notifyChanged(newKey, valOld, valNew);
                continue;
            }
            this.notifyAdded(newKey, newConfig.get(newKey));
        }
        for (String key : oldKeys) {
            if (newKeys.contains(key)) continue;
            this.notifyRemoved(key, oldConfig.get(key));
        }
    }

    private void notifyAdded(Map<String, String> m) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> e : m.entrySet()) {
            this.notifyAdded(e.getKey(), e.getValue());
        }
    }

    private void notifyAdded(String key, String value) {
        for (ConfigListener l : this.listeners.getView()) {
            l.added(key, value);
        }
    }

    private void notifyRemoved(String key, String oldValue) {
        for (ConfigListener l : this.listeners.getView()) {
            l.removed(key, oldValue);
        }
    }

    private void notifyChanged(String key, String oldValue, String newValue) {
        for (ConfigListener l : this.listeners.getView()) {
            l.changed(key, oldValue, newValue);
        }
    }

    public String get(String key) {
        Map<String, String> c = this.config;
        return c == null ? null : c.get(key);
    }

    public String get(String key, String def) {
        String v = this.get(key);
        return v == null ? def : v;
    }

    public Integer getInt(String key) {
        String v = this.get(key);
        return v == null ? null : Integer.valueOf(Integer.parseInt(v));
    }

    public int getInt(String key, int def) {
        String v = this.get(key);
        return v == null ? def : Integer.parseInt(v);
    }

    public Long getLong(String key) {
        String v = this.get(key);
        return v == null ? null : Long.valueOf(Long.parseLong(v));
    }

    public long getLong(String key, long def) {
        String v = this.get(key);
        return v == null ? def : Long.parseLong(v);
    }

    public Boolean getBool(String key) {
        String v = this.get(key);
        return v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v));
    }

    public boolean getBool(String key, boolean def) {
        String v = this.get(key);
        return v == null ? def : Boolean.parseBoolean(v);
    }

    public Double getDouble(String key) {
        String v = this.get(key);
        return v == null ? null : Double.valueOf(Double.parseDouble(v));
    }

    public double getDouble(String key, double def) {
        String v = this.get(key);
        return v == null ? def : Double.parseDouble(v);
    }
}

