/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.lang.ArrayUtil;
import ch.bind.philib.validation.Validation;
import java.util.HashSet;
import java.util.Set;

public final class CowSet<E> {
    private final Class<E> clazz;
    private final Set<E> content = new HashSet();
    private volatile E[] empty;
    private volatile E[] view;

    public CowSet(Class<E> clazz) {
        Validation.notNull(clazz);
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        Set<E> set = this.content;
        synchronized (set) {
            boolean update = this.content.add(e);
            if (update) {
                this.updateView();
            }
            return update;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(E e) {
        if (e == null) {
            return false;
        }
        Set<E> set = this.content;
        synchronized (set) {
            boolean update = this.content.remove(e);
            if (update) {
                this.updateView();
            }
            return update;
        }
    }

    private void updateView() {
        int n = this.content.size();
        this.view = n == 0 ? null : ArrayUtil.toArray(this.clazz, this.content);
    }

    public E[] getView() {
        E[] v = this.view;
        if (v == null) {
            return this.getEmpty();
        }
        return v;
    }

    public boolean isEmpty() {
        E[] v = this.view;
        return v == null || v.length == 0;
    }

    public int size() {
        E[] v = this.view;
        return v == null ? 0 : v.length;
    }

    private E[] getEmpty() {
        E[] e = this.empty;
        if (e == null) {
            this.empty = e = ArrayUtil.newArray(this.clazz, 0);
        }
        return e;
    }
}

