/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.Cache;
import ch.bind.philib.lang.Cloner;
import ch.bind.philib.lang.ClonerNoop;
import ch.bind.philib.lang.MurmurHash;
import ch.bind.philib.validation.Validation;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class LineCache<K, V>
implements Cache<K, V> {
    static final int DEFAULT_ORDER = 8;
    private final AtomicReferenceArray<Entry<K, V>> entries;
    private final AtomicLong[] lineClocks;
    private final Cloner<V> valueCloner;
    private final int lineMask;
    private final int order;

    public LineCache() {
        this(256, 8, null);
    }

    public LineCache(int capacity, int order) {
        this(capacity, order, null);
    }

    public LineCache(Cloner<V> valueCloner) {
        this(256, 8, valueCloner);
    }

    public LineCache(int capacity, int order, Cloner<V> valueCloner) {
        Validation.isTrue(capacity > 0 && order > 0, "capacity and order must be greater than zero");
        Validation.isTrue(Integer.bitCount(order) == 1, "order must be a power of two");
        Validation.isTrue(capacity % order == 0, "capacity must be a multiple of order");
        int lines = capacity / order;
        this.entries = new AtomicReferenceArray(capacity);
        this.lineClocks = new AtomicLong[lines];
        for (int i = 0; i < lines; ++i) {
            this.lineClocks[i] = new AtomicLong();
        }
        this.valueCloner = ClonerNoop.getIfNull(valueCloner);
        this.order = order;
        this.lineMask = lines - 1;
    }

    @Override
    public void set(K key, V value) {
        Entry<K, V> lowestClock;
        int lowestClockIdx;
        Validation.notNull(key);
        Validation.notNull(value);
        int hash = LineCache.hash(key);
        int line = Math.abs(hash) & this.lineMask;
        int startIdx = line * this.order;
        int endIdx = startIdx + this.order;
        long clock = this.lineClocks[line].getAndIncrement();
        Entry<K, V> newEntry = new Entry<K, V>(clock, key, hash, value);
        do {
            int emptyIdx = -1;
            lowestClockIdx = -1;
            lowestClock = null;
            for (int i = startIdx; i < endIdx; ++i) {
                Entry<K, V> e = this.entries.get(i);
                if (e == null) {
                    emptyIdx = i;
                    continue;
                }
                if (e.matches(key, hash)) {
                    if (e.clock < clock) {
                        this.entries.compareAndSet(i, e, newEntry);
                    }
                    return;
                }
                if (lowestClock != null && e.clock >= lowestClock.clock) continue;
                lowestClock = e;
                lowestClockIdx = i;
            }
            if (emptyIdx == -1 || !this.entries.compareAndSet(emptyIdx, null, newEntry)) continue;
            return;
        } while (lowestClockIdx == -1 || !this.entries.compareAndSet(lowestClockIdx, lowestClock, newEntry));
    }

    private static int hash(Object o) {
        return MurmurHash.murmur3_finalize_mix32(o.hashCode());
    }

    @Override
    public V get(K key) {
        Validation.notNull(key);
        int hash = LineCache.hash(key);
        int line = Math.abs(hash) & this.lineMask;
        int startIdx = line * this.order;
        int endIdx = startIdx + this.order;
        Entry<K, V> found = null;
        for (int i = startIdx; i < endIdx; ++i) {
            Entry<K, V> e = this.entries.get(i);
            if (e == null || !e.matches(key, hash)) continue;
            if (found == null) {
                found = e;
                continue;
            }
            if (e.clock <= found.clock) continue;
            this.entries.compareAndSet(i, found, null);
            found = e;
        }
        return found == null ? null : (V)this.valueCloner.clone(found.value);
    }

    @Override
    public void remove(K key) {
        Validation.notNull(key);
        int hash = LineCache.hash(key);
        int line = Math.abs(hash) & this.lineMask;
        int startIdx = line * this.order;
        for (int o = 0; o < this.order; ++o) {
            int idx = startIdx + o;
            Entry<K, V> e = this.entries.get(idx);
            if (e == null || !e.matches(key, hash)) continue;
            this.entries.compareAndSet(idx, e, null);
            return;
        }
    }

    @Override
    public int capacity() {
        return this.entries.length();
    }

    @Override
    public void clear() {
        int cap = this.entries.length();
        for (int i = 0; i < cap; ++i) {
            this.entries.lazySet(i, null);
        }
        this.entries.set(0, null);
    }

    private static final class Entry<K, V> {
        final long clock;
        final K key;
        final V value;
        final int hash;

        public Entry(long clock, K key, int hash, V value) {
            this.clock = clock;
            this.key = key;
            this.value = value;
            this.hash = hash;
        }

        boolean matches(K k, int h) {
            return this.hash == h && (this.key == k || this.key.equals(k));
        }
    }
}

