/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.Cache;
import ch.bind.philib.cache.StagedLruCacheEntry;
import ch.bind.philib.lang.Cloner;
import ch.bind.philib.lang.ClonerNoop;
import ch.bind.philib.math.Calc;
import ch.bind.philib.util.ClusteredHashIndex;
import ch.bind.philib.util.ClusteredIndex;
import ch.bind.philib.util.LruList;
import ch.bind.philib.validation.Validation;

public final class StagedLruCache<K, V>
implements Cache<K, V> {
    public static final double DEFAULT_OLD_GEN_RATIO = 0.25;
    public static final int DEFAULT_OLD_GEN_AFTER_HITS = 10;
    private static final double MIN_OLD_GEN_RATIO = 0.1;
    private static final double MAX_OLD_GEN_RATIO = 0.9;
    private final LruList<StagedLruCacheEntry<K, V>> lruYoungGen;
    private final LruList<StagedLruCacheEntry<K, V>> lruOldGen;
    private final ClusteredIndex<K, StagedLruCacheEntry<K, V>> index;
    private final Cloner<V> valueCloner;
    private final int oldGenAfterHits;
    private final int capacity;

    public StagedLruCache() {
        this(256);
    }

    public StagedLruCache(int capacity) {
        this(capacity, null, 0.25, 10);
    }

    public StagedLruCache(Cloner<V> valueCloner) {
        this(256, valueCloner, 0.25, 10);
    }

    public StagedLruCache(int capacity, Cloner<V> valueCloner, double oldGenRatio, int oldGenAfterHits) {
        Validation.isTrue(capacity > 0, "capacity must be greater than 0");
        this.capacity = capacity;
        this.oldGenAfterHits = Math.max(1, oldGenAfterHits);
        oldGenRatio = Calc.clip(oldGenRatio, 0.1, 0.9);
        int oldCap = (int)((double)this.capacity * oldGenRatio);
        int youngCap = this.capacity - oldCap;
        this.lruYoungGen = new LruList(youngCap);
        this.lruOldGen = new LruList(oldCap);
        this.index = new ClusteredHashIndex<K, StagedLruCacheEntry<K, V>>(capacity);
        this.valueCloner = ClonerNoop.getIfNull(valueCloner);
    }

    @Override
    public synchronized void set(K key, V value) {
        Validation.notNull(key);
        Validation.notNull(value);
        StagedLruCacheEntry<K, V> entry = this.index.get(key);
        if (entry == null) {
            entry = new StagedLruCacheEntry<K, V>(key, value);
            this.index.add(entry);
            this.addYoungGen(entry);
        } else {
            entry.setValue(value);
        }
    }

    @Override
    public synchronized V get(K key) {
        Validation.notNull(key);
        StagedLruCacheEntry<K, V> entry = this.index.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isInYoungGen()) {
            int hits = entry.recordHit();
            if (hits >= this.oldGenAfterHits) {
                entry.resetHits();
                this.lruYoungGen.remove(entry);
                this.addOldGen(entry);
            } else {
                this.lruYoungGen.moveToHead(entry);
            }
        } else {
            this.lruOldGen.moveToHead(entry);
        }
        return this.valueCloner.clone(entry.getValue());
    }

    @Override
    public synchronized void remove(K key) {
        Validation.notNull(key);
        this.removeLruAndIndex(this.index.get(key));
    }

    @Override
    public synchronized int capacity() {
        return this.capacity;
    }

    @Override
    public synchronized void clear() {
        this.lruYoungGen.clear();
        this.lruOldGen.clear();
        this.index.clear();
    }

    private void removeLruAndIndex(StagedLruCacheEntry<K, V> entry) {
        if (entry != null) {
            this.index.remove(entry);
            if (entry.isInYoungGen()) {
                this.lruYoungGen.remove(entry);
            } else {
                this.lruOldGen.remove(entry);
            }
        }
    }

    private void addYoungGen(StagedLruCacheEntry<K, V> entry) {
        entry.setInYoungGen();
        StagedLruCacheEntry<K, V> removed = this.lruYoungGen.add(entry);
        if (removed != null) {
            this.index.remove(removed);
        }
    }

    private void addOldGen(StagedLruCacheEntry<K, V> entry) {
        entry.setInOldGen();
        StagedLruCacheEntry<K, V> removed = this.lruOldGen.add(entry);
        if (removed != null) {
            this.addYoungGen(removed);
        }
    }
}

