/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SingleFlight {
    private final ConcurrentMap<Object, Call> calls = new ConcurrentHashMap<Object, Call>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V execute(Object key, Callable<V> callable) throws Exception {
        Call<V> call = (Call<V>)this.calls.get(key);
        if (call == null) {
            call = new Call<V>();
            Call other = this.calls.putIfAbsent(key, call);
            if (other == null) {
                try {
                    Object v = call.exec(callable);
                    return v;
                }
                finally {
                    this.calls.remove(key);
                }
            }
            call = other;
        }
        return call.await();
    }

    private static class Call<V> {
        private final Object lock = new Object();
        private boolean finished;
        private V result;
        private Exception exc;

        private Call() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finished(V result, Exception exc) {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                this.result = result;
                this.exc = exc;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V await() throws Exception {
            Object object = this.lock;
            synchronized (object) {
                while (!this.finished) {
                    this.lock.wait();
                }
                if (this.exc != null) {
                    throw this.exc;
                }
                return this.result;
            }
        }

        V exec(Callable<V> callable) throws Exception {
            V result = null;
            Exception exc = null;
            try {
                V v = result = (V)callable.call();
                return v;
            }
            catch (Exception e) {
                exc = e;
                throw e;
            }
            finally {
                this.finished(result, exc);
            }
        }
    }
}

