/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

import ch.bind.philib.io.DoubleSidedBuffer;
import ch.bind.philib.validation.Validation;

public final class RingBuffer
implements DoubleSidedBuffer {
    public static final int DEFAULT_CAPACITY = 8192;
    private byte[] ringBuf;
    private int ringCapacity;
    private int ringOffset;
    private int ringSize;

    public RingBuffer() {
        this(8192);
    }

    public RingBuffer(int capacity) {
        Validation.notNegative(capacity, "capacity must not be negative");
        this.init(capacity);
    }

    @Override
    public int available() {
        return this.ringSize;
    }

    @Override
    public boolean isEmpty() {
        return this.ringSize == 0;
    }

    @Override
    public int capacity() {
        return this.ringCapacity;
    }

    @Override
    public void clear() {
        this.ringOffset = 0;
        this.ringSize = 0;
    }

    @Override
    public void read(byte[] data) {
        RingBuffer.check(data);
        this.readFront(data, 0, data.length);
    }

    @Override
    public void read(byte[] data, int off, int len) {
        RingBuffer.check(data, off, len);
        this.readFront(data, off, len);
    }

    @Override
    public void readBack(byte[] data) {
        RingBuffer.check(data);
        this._readBack(data, 0, data.length);
    }

    @Override
    public void readBack(byte[] data, int off, int len) {
        RingBuffer.check(data, off, len);
        this._readBack(data, off, len);
    }

    @Override
    public void write(byte[] data) {
        RingBuffer.check(data);
        this._write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int off, int len) {
        RingBuffer.check(data, off, len);
        this._write(data, off, len);
    }

    @Override
    public void writeFront(byte[] data) {
        RingBuffer.check(data);
        this._writeFront(data, 0, data.length);
    }

    @Override
    public void writeFront(byte[] data, int off, int len) {
        RingBuffer.check(data, off, len);
        this._writeFront(data, off, len);
    }

    private void readFront(byte[] data, int off, int len) {
        if (len == 0) {
            return;
        }
        this.readLenCheck(len);
        this.copyFromRingBufFront(data, off, len);
        this.consumedFront(len);
    }

    private void _readBack(byte[] data, int off, int len) {
        if (len == 0) {
            return;
        }
        this.readLenCheck(len);
        this.copyFromRingBufBack(data, off, len);
        this.consumedBack(len);
    }

    private void _write(byte[] data, int off, int len) {
        int newSize = this.ringSize + len;
        this._ensureBufferSize(newSize);
        this.copyToRingBufBack(data, off, len);
        this.ringSize = newSize;
    }

    private void _writeFront(byte[] data, int off, int len) {
        int newSize = this.ringSize + len;
        this._ensureBufferSize(newSize);
        this.copyToRingBufFront(data, off, len);
        this.ringSize = newSize;
        this.ringOffset = this.offsetMinus(len);
    }

    private void init(int capacity) {
        this.ringCapacity = capacity;
        this.ringBuf = new byte[capacity];
    }

    private void _ensureBufferSize(int requiredSpace) {
        int newCap;
        if (requiredSpace <= this.ringCapacity) {
            return;
        }
        for (newCap = this.ringCapacity * 2; newCap < requiredSpace; newCap *= 2) {
        }
        byte[] newBuf = new byte[newCap];
        this.copyFromRingBufFront(newBuf, 0, this.ringSize);
        this.ringBuf = newBuf;
        this.ringCapacity = newCap;
        this.ringOffset = 0;
    }

    private void copyFromRingBufFront(byte[] buf, int off, int len) {
        int availToEnd = this.ringCapacity - this.ringOffset;
        if (availToEnd >= len) {
            RingBuffer.ac(this.ringBuf, this.ringOffset, buf, off, len);
        } else {
            int rem = len - availToEnd;
            RingBuffer.ac(this.ringBuf, this.ringOffset, buf, off, availToEnd);
            RingBuffer.ac(this.ringBuf, 0, buf, off + availToEnd, rem);
        }
    }

    private void copyFromRingBufBack(byte[] buf, int off, int len) {
        int firstReadOffset = this.offsetPlus(this.ringSize - len);
        int availToEnd = this.ringCapacity - firstReadOffset;
        int numReadOne = Math.min(availToEnd, len);
        int numReadTwo = len - numReadOne;
        RingBuffer.ac(this.ringBuf, firstReadOffset, buf, off, numReadOne);
        if (numReadTwo > 0) {
            RingBuffer.ac(this.ringBuf, 0, buf, off + numReadOne, numReadTwo);
        }
    }

    private void copyToRingBufBack(byte[] data, int off, int len) {
        int writePosOne = this.offsetPlus(this.ringSize);
        int availBack = this.ringCapacity - writePosOne;
        int numWriteOne = Math.min(availBack, len);
        int numWriteTwo = len - numWriteOne;
        RingBuffer.ac(data, off, this.ringBuf, writePosOne, numWriteOne);
        if (numWriteTwo > 0) {
            RingBuffer.ac(data, off + numWriteOne, this.ringBuf, 0, numWriteTwo);
        }
    }

    private void copyToRingBufFront(byte[] data, int off, int len) {
        int writePosOne = this.offsetMinus(len);
        int availBack = this.ringCapacity - writePosOne;
        int numWriteOne = Math.min(availBack, len);
        RingBuffer.ac(data, off, this.ringBuf, writePosOne, numWriteOne);
        int numWriteTwo = len - numWriteOne;
        if (numWriteTwo > 0) {
            RingBuffer.ac(data, off + numWriteOne, this.ringBuf, 0, numWriteTwo);
        }
    }

    private void consumedFront(int len) {
        this.ringSize -= len;
        this.ringOffset = this.ringSize == 0 ? 0 : this.offsetPlus(len);
    }

    private void consumedBack(int len) {
        this.ringSize -= len;
        if (this.ringSize == 0) {
            this.ringOffset = 0;
        }
    }

    private void readLenCheck(int len) {
        if (this.ringSize < len) {
            throw new IllegalArgumentException("not enough data in buffer");
        }
    }

    private int offsetPlus(int shift) {
        int offset = this.ringOffset + shift;
        return offset %= this.ringCapacity;
    }

    private int offsetMinus(int shift) {
        int offset = this.ringOffset - shift;
        if (offset < 0) {
            offset += this.ringCapacity;
        }
        return offset;
    }

    private static void check(byte[] data) {
        Validation.notNull(data, "data-buffer must not be null");
    }

    private static void check(byte[] data, int off, int len) {
        RingBuffer.check(data);
        Validation.notNegative(off, "offset must not be negative");
        Validation.notNegative(len, "length must not be negative");
        if (len > data.length - off) {
            throw new IllegalArgumentException("not enough space in buffer");
        }
    }

    private static void ac(byte[] src, int srcPos, byte[] dst, int dstPos, int length) {
        System.arraycopy(src, srcPos, dst, dstPos, length);
    }
}

