/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

import java.io.Closeable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SafeCloseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SafeCloseUtil.class);

    protected SafeCloseUtil() {
    }

    public static void close(Closeable closeable) {
        SafeCloseUtil.close(closeable, LOG);
    }

    public static void close(Object obj) {
        SafeCloseUtil.close(obj, LOG);
    }

    public static void close(Closeable closeable, Logger logger) {
        if (closeable == null) {
            return;
        }
        if (logger == null) {
            logger = LOG;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.error("error while closing a resource: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Object obj, Logger logger) {
        Method closeMethod;
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            SafeCloseUtil.close((Closeable)obj, logger);
            return;
        }
        if (logger == null) {
            logger = LOG;
        }
        try {
            closeMethod = obj.getClass().getMethod("close", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.warn("close method not found on class: " + obj.getClass().getName());
            return;
        }
        catch (SecurityException e) {
            logger.warn("cannot access close method on class: " + obj.getClass().getName());
            return;
        }
        try {
            closeMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            logger.error("error while closing a resource: " + e.getMessage(), (Throwable)e);
        }
    }
}

