/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.lang.StringUtil;

public abstract class ExceptionUtil {
    protected ExceptionUtil() {
    }

    public static String buildMessageChain(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        ExceptionUtil.add(sb, t);
        for (t = t.getCause(); t != null; t = t.getCause()) {
            sb.append(" => ");
            ExceptionUtil.add(sb, t);
        }
        return sb.toString();
    }

    private static void add(StringBuilder sb, Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        if (trace != null && trace.length > 0 && trace[0] != null) {
            StackTraceElement ste = trace[0];
            int line = ste.getLineNumber();
            String simpleName = StringUtil.extractBack(ste.getClassName(), '.');
            sb.append(simpleName).append('.').append(ste.getMethodName());
            if (line >= 0) {
                sb.append(':').append(line);
            }
            sb.append('#');
        }
        sb.append(t.getClass().getSimpleName());
        String msg = t.getMessage();
        if (msg == null) {
            sb.append("()");
        } else {
            sb.append('(');
            sb.append(msg);
            sb.append(')');
        }
    }
}

