/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.lang.MurmurHash;

public abstract class HashUtil {
    protected HashUtil() {
    }

    public static int startHash(boolean value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(byte value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(char value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(short value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(int value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(long value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(float value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(double value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(Object obj) {
        return HashUtil.nextHash(-1756908916, obj);
    }

    public static int startHash(boolean[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(byte[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(char[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(short[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(int[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(long[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(float[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(double[] values) {
        return HashUtil.nextHash(-1756908916, values);
    }

    public static int startHash(Object[] objs) {
        return HashUtil.nextHash(-1756908916, objs);
    }

    public static int nextHash(int hash, boolean value) {
        return MurmurHash.murmur2a_8bit(hash, value ? 1 : 0);
    }

    public static int nextHash(int hash, byte value) {
        return MurmurHash.murmur2a_8bit(hash, value & 0xFF);
    }

    public static int nextHash(int hash, char value) {
        return MurmurHash.murmur2a_16bit(hash, value);
    }

    public static int nextHash(int hash, short value) {
        return MurmurHash.murmur2a_16bit(hash, value);
    }

    public static int nextHash(int hash, int value) {
        return MurmurHash.murmur2a_32bit(hash, value);
    }

    public static int nextHash(int hash, long value) {
        return MurmurHash.murmur2a_64bit(hash, value);
    }

    public static int nextHash(int hash, float value) {
        return HashUtil.nextHash(hash, HashUtil.fromFloat(value));
    }

    public static int nextHash(int hash, double value) {
        return HashUtil.nextHash(hash, HashUtil.fromDouble(value));
    }

    public static int nextHash(int hash, Object obj) {
        int objHash = obj == null ? 0 : obj.hashCode();
        return MurmurHash.murmur2a_32bit(hash, objHash);
    }

    public static int nextHash(int hash, boolean[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (boolean value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, byte[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        return MurmurHash.murmur2a(hash, values);
    }

    public static int nextHash(int hash, char[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (char value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, short[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (short value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, int[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (int value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, long[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (long value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, float[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (float value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, double[] values) {
        if (values == null || values.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, values.length);
        for (double value : values) {
            hash = HashUtil.nextHash(hash, value);
        }
        return hash;
    }

    public static int nextHash(int hash, Object[] objects) {
        if (objects == null || objects.length == 0) {
            return MurmurHash.murmur2a_32bit(hash, 0);
        }
        hash = MurmurHash.murmur2a_32bit(hash, objects.length);
        for (Object object : objects) {
            hash = HashUtil.nextHash(hash, object);
        }
        return hash;
    }

    public static int fromFloat(float value) {
        return Float.floatToIntBits(value);
    }

    public static long fromDouble(double value) {
        return Double.doubleToLongBits(value);
    }
}

