/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

public abstract class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected StringUtil() {
    }

    public static String extractBack(String s, char delim) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        int l = s.length();
        int start = 0;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c != delim) continue;
            start = i + 1;
        }
        if (start == l) {
            return "";
        }
        return s.substring(start, l);
    }

    public static int count(String str, int value) {
        int off;
        if (str == null || str.length() == 0) {
            return 0;
        }
        int n = 0;
        int fromIdx = 0;
        while ((off = str.indexOf(value, fromIdx)) != -1) {
            fromIdx = off + 1;
            ++n;
        }
        return n;
    }

    public static String[] split(String str, int delimiter) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int n = StringUtil.count(str, delimiter);
        if (n == 0) {
            return new String[]{str};
        }
        String[] parts = new String[n + 1];
        int i = 0;
        int fromIdx = 0;
        while (true) {
            int off;
            int partLen;
            if ((partLen = (off = str.indexOf(delimiter, fromIdx)) == -1 ? len - fromIdx : off - fromIdx) > 0) {
                parts[i++] = str.substring(fromIdx, fromIdx + partLen);
            }
            if (off == -1) break;
            fromIdx = off + 1;
        }
        if (i == parts.length) {
            return parts;
        }
        String[] rv = new String[i];
        System.arraycopy(parts, 0, rv, 0, i);
        return rv;
    }
}

