/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.validation;

import java.util.Collection;
import java.util.Map;

public abstract class Validation {
    protected Validation() {
    }

    public static int notNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must not be negative");
        }
        return value;
    }

    public static int notNegative(int value, String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static long notNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must not be negative");
        }
        return value;
    }

    public static long notNegative(long value, String message) {
        if (value < 0L) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T> T notNull(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        return obj;
    }

    public static <T> T notNull(T obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static boolean isTrue(boolean value) {
        if (!value) {
            throw new IllegalArgumentException("value must be true");
        }
        return true;
    }

    public static boolean isTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isFalse(boolean value) {
        if (value) {
            throw new IllegalArgumentException("value must be false");
        }
        return false;
    }

    public static boolean isFalse(boolean value, String message) {
        if (value) {
            throw new IllegalArgumentException(message);
        }
        return false;
    }

    public static <T extends CharSequence> T notNullOrEmpty(T value) {
        return Validation.notNullOrEmpty(value, "null or empty char sequence provided");
    }

    public static <T extends CharSequence> T notNullOrEmpty(T value, String message) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Collection<?>> T notNullOrEmpty(T value) {
        return Validation.notNullOrEmpty(value, "null or empty collection provided");
    }

    public static <T extends Collection<?>> T notNullOrEmpty(T value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Map<?, ?>> T notNullOrEmpty(T value) {
        return Validation.notNullOrEmpty(value, "null or empty collection provided");
    }

    public static <T extends Map<?, ?>> T notNullOrEmpty(T value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T> T[] notNullOrEmpty(T[] values) {
        return Validation.notNullOrEmpty(values, "null or empty array provided");
    }

    public static <T> T[] notNullOrEmpty(T[] values, String message) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return values;
    }

    public static <T> T[] noNullValues(T[] values) {
        return Validation.noNullValues(values, "array contains null values");
    }

    public static <T> T[] noNullValues(T[] values, String message) {
        Validation.notNull(values);
        for (T v : values) {
            Validation.notNull(v, message);
        }
        return values;
    }

    public static void equalLengths(Object[][] matrix) {
        Validation.equalLengths(matrix, "multi dimensional array contains sub-arrays of different length");
    }

    public static void equalLengths(Object[][] matrix, String message) {
        Validation.notNull(matrix);
        if (matrix.length < 2) {
            return;
        }
        int l = matrix[0].length;
        for (int i = 1; i < matrix.length; ++i) {
            if (matrix[i].length == l) continue;
            throw new IllegalArgumentException(message);
        }
    }
}

