/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.ObjectCache;
import ch.bind.philib.cache.SpecificCacheBase;
import ch.bind.philib.cache.impl.LinkedObjectCache;
import ch.bind.philib.cache.impl.ObjectFactory;
import ch.bind.philib.cache.impl.ScalableObjectCache;
import ch.bind.philib.io.BufferOps;
import java.nio.ByteBuffer;

public final class ByteBufferCache
extends SpecificCacheBase<ByteBuffer> {
    private ByteBufferCache(ObjectCache<ByteBuffer> cache) {
        super(cache);
    }

    public static ByteBufferCache createSimple(int bufferSize, int maxEntries) {
        ObjectFactory<ByteBuffer> factory = ByteBufferCache.createFactory(bufferSize);
        LinkedObjectCache<ByteBuffer> cache = new LinkedObjectCache<ByteBuffer>(factory, maxEntries);
        return new ByteBufferCache((ObjectCache<ByteBuffer>)cache);
    }

    public static ByteBufferCache createScalable(int bufferSize, int maxEntries) {
        ObjectFactory<ByteBuffer> factory = ByteBufferCache.createFactory(bufferSize);
        ScalableObjectCache<ByteBuffer> cache = new ScalableObjectCache<ByteBuffer>(factory, maxEntries);
        return new ByteBufferCache((ObjectCache<ByteBuffer>)cache);
    }

    public static ByteBufferCache createScalable(int bufferSize, int maxEntries, int bufferBuckets) {
        ObjectFactory<ByteBuffer> factory = ByteBufferCache.createFactory(bufferSize);
        ScalableObjectCache<ByteBuffer> cache = new ScalableObjectCache<ByteBuffer>(factory, maxEntries, bufferBuckets);
        return new ByteBufferCache((ObjectCache<ByteBuffer>)cache);
    }

    public static ObjectFactory<ByteBuffer> createFactory(int bufferSize) {
        return new ByteBufferFactory(bufferSize);
    }

    private static final class ByteBufferFactory
    implements ObjectFactory<ByteBuffer> {
        private final int bufferSize;

        ByteBufferFactory(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public ByteBuffer create() {
            return ByteBuffer.allocateDirect(this.bufferSize);
        }

        @Override
        public void destroy(ByteBuffer e) {
        }

        @Override
        public boolean prepareForReuse(ByteBuffer e) {
            if (e.capacity() == this.bufferSize) {
                BufferOps.memsetZero(e);
                return true;
            }
            return false;
        }

        @Override
        public boolean canReuse(ByteBuffer e) {
            return true;
        }
    }
}

