/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache.impl;

import ch.bind.philib.cache.CacheStats;
import ch.bind.philib.cache.ObjectCache;
import ch.bind.philib.cache.impl.CombinedCacheStats;
import ch.bind.philib.cache.impl.LinkedObjectCache;
import ch.bind.philib.cache.impl.ObjectFactory;
import ch.bind.philib.validation.Validation;
import java.util.concurrent.atomic.AtomicLong;

public final class ScalableObjectCache<E>
implements ObjectCache<E> {
    private final CacheThreadLocal cacheByThread = new CacheThreadLocal();
    private final LinkedObjectCache<E>[] caches;
    private final AtomicLong usageCount = new AtomicLong(0L);
    private final CombinedCacheStats stats;

    public ScalableObjectCache(ObjectFactory<E> factory, int maxEntries) {
        this(factory, maxEntries, Runtime.getRuntime().availableProcessors());
    }

    public ScalableObjectCache(ObjectFactory<E> factory, int maxEntries, int numBuckets) {
        Validation.notNull(factory);
        int entriesPerBucket = maxEntries / numBuckets;
        if (maxEntries % numBuckets != 0) {
            ++entriesPerBucket;
        }
        this.caches = new LinkedObjectCache[numBuckets];
        CacheStats[] s = new CacheStats[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.caches[i] = new LinkedObjectCache<E>(factory, entriesPerBucket);
            s[i] = this.caches[i].getCacheStats();
        }
        this.stats = new CombinedCacheStats(s);
    }

    @Override
    public E acquire() {
        return ((LinkedObjectCache)this.cacheByThread.get()).acquire();
    }

    @Override
    public void release(E e) {
        ((LinkedObjectCache)this.cacheByThread.get()).release(e);
    }

    @Override
    public CacheStats getCacheStats() {
        return this.stats;
    }

    LinkedObjectCache<E> bind() {
        long v = this.usageCount.getAndIncrement();
        int cacheIdx = (int)(v % (long)this.caches.length);
        return this.caches[cacheIdx];
    }

    private final class CacheThreadLocal
    extends ThreadLocal<LinkedObjectCache<E>> {
        private CacheThreadLocal() {
        }

        @Override
        protected LinkedObjectCache<E> initialValue() {
            return ScalableObjectCache.this.bind();
        }
    }
}

