/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

import ch.bind.philib.io.OverflowException;
import ch.bind.philib.io.Ring;

public final class RingImpl<T>
implements Ring<T> {
    private static final int INITIAL_RING_LEN = 4;
    private static final int RING_LEN_ENHANCING_FACTOR = 2;
    private int off;
    private int size;
    private Object[] ring;

    @Override
    public void addBack(T value) {
        assert (this.size >= 0 && (this.ring == null || this.size <= this.ring.length));
        if (value == null) {
            return;
        }
        this.ensureRingSpace();
        int addPos = (this.off + this.size) % this.ring.length;
        this.ring[addPos] = value;
        ++this.size;
    }

    @Override
    public void addFront(T value) {
        assert (this.size >= 0 && (this.ring == null || this.size <= this.ring.length));
        if (value == null) {
            return;
        }
        this.ensureRingSpace();
        this.off = this.off > 0 ? this.off - 1 : this.ring.length - 1;
        this.ring[this.off] = value;
        ++this.size;
    }

    @Override
    public T poll() {
        assert (this.size >= 0 && (this.ring == null || this.size <= this.ring.length));
        if (this.size == 0) {
            return null;
        }
        Object value = this.ring[this.off];
        this.ring[this.off] = null;
        this.off = (this.off + 1) % this.ring.length;
        --this.size;
        assert (value != null);
        return (T)value;
    }

    @Override
    public T pollNext(T value) {
        assert (this.size >= 0 && (this.ring == null || this.size <= this.ring.length));
        if (this.size == 0) {
            return value;
        }
        T rv = this.poll();
        if (value != null) {
            this.addBack(value);
        }
        assert (rv != null);
        return rv;
    }

    @Override
    public boolean isEmpty() {
        assert (this.size >= 0 && (this.ring == null || this.size <= this.ring.length));
        return this.size == 0;
    }

    @Override
    public int size() {
        assert (this.size >= 0 && (this.ring == null || this.size <= this.ring.length));
        return this.size;
    }

    @Override
    public void clear() {
        this.off = 0;
        this.size = 0;
        this.ring = null;
    }

    private void ensureRingSpace() {
        if (this.ring == null) {
            this.ring = new Object[4];
        } else {
            int l = this.ring.length;
            if (this.size == l) {
                int newLen = l * 2;
                if (newLen < 0) {
                    if (l == Integer.MAX_VALUE) {
                        throw new OverflowException("size of " + this.getClass().getSimpleName() + " is at Integer.MAX_VALUE, can't add another value");
                    }
                    newLen = Integer.MAX_VALUE;
                }
                this.setRingSize(newLen);
            }
        }
    }

    @Override
    public void shrink() {
        if (this.ring != null && this.ring.length > this.size) {
            int optimalLen;
            for (optimalLen = 4; optimalLen < this.size; optimalLen *= 2) {
            }
            if (optimalLen < this.ring.length) {
                this.setRingSize(optimalLen);
            }
        }
    }

    private void setRingSize(int len) {
        Object[] newRing = new Object[len];
        RingImpl.copyRingData(this.ring, this.off, this.size, newRing);
        this.ring = newRing;
        this.off = 0;
    }

    private static final void copyRingData(Object[] oldRing, int off, int used, Object[] newRing) {
        assert (oldRing != null && newRing != null && off >= 0 && off < oldRing.length && used >= 0 && used <= oldRing.length && newRing.length >= used);
        if (off == 0) {
            System.arraycopy(oldRing, 0, newRing, 0, used);
        } else {
            int numToEnd = used - off;
            System.arraycopy(oldRing, off, newRing, 0, numToEnd);
            System.arraycopy(oldRing, 0, newRing, numToEnd, off);
            off = 0;
        }
    }
}

