/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import java.util.concurrent.atomic.AtomicInteger;

public final class ServiceState {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_OPEN = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private AtomicInteger state = new AtomicInteger(0);

    public boolean isUninitialized() {
        return this.state.get() == 0;
    }

    public boolean isOpen() {
        return this.state.get() == 1;
    }

    public boolean isClosing() {
        return this.state.get() == 2;
    }

    public boolean isClosed() {
        return this.state.get() == 3;
    }

    public boolean isClosingOrClosed() {
        return this.state.get() >= 2;
    }

    public void setOpen() {
        this.switchState(1);
    }

    public void setClosing() {
        this.switchState(2);
    }

    public void setClosed() {
        this.switchState(3);
    }

    private void switchState(int newState) {
        int stateNow;
        do {
            if (newState >= (stateNow = this.state.get())) continue;
            throw new IllegalStateException("service-states can only be moved forward");
        } while (!this.state.compareAndSet(stateNow, newState));
    }
}

