/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

public final class ToStringUtil {
    private ToStringUtil() {
    }

    public static String matrixOutput(String[][] matrix) {
        ToStringUtil.checkMatrix(matrix);
        StringBuilder sb = new StringBuilder();
        int N = matrix.length;
        if (N == 0) {
            return "";
        }
        int M = matrix[0].length;
        int max = 0;
        for (int x = 0; x < N; ++x) {
            for (int y = 0; y < M; ++y) {
                int len;
                String str = matrix[x][y];
                if (str == null || (len = matrix[x][y].length()) <= max) continue;
                max = len;
            }
        }
        int linelen = N * max + (N - 1) * 3;
        char[] linepad = new char[linelen + 2];
        for (int x = 1; x <= linelen; ++x) {
            linepad[x] = 45;
        }
        linepad[linelen + 1] = 10;
        linepad[0] = 10;
        for (int y = 0; y < M; ++y) {
            for (int x = 0; x < N; ++x) {
                String val;
                if (x != 0) {
                    sb.append(' ');
                }
                if ((val = matrix[x][y]) == null) {
                    val = "";
                }
                int len = val.length();
                int pad = max - len;
                for (int p = 0; p < pad; ++p) {
                    sb.append(' ');
                }
                sb.append(val);
                if (x >= N - 1) continue;
                sb.append(" |");
            }
            sb.append(linepad);
        }
        return sb.toString();
    }

    private static void checkMatrix(String[][] matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix == null");
        }
        int N = matrix.length;
        if (N > 0) {
            String[] first = matrix[0];
            if (first == null) {
                throw new IllegalArgumentException("matrix[0] == null");
            }
            int M = first.length;
            for (int i = 1; i < N; ++i) {
                String[] cur = matrix[i];
                if (cur == null) {
                    throw new IllegalArgumentException("matrix[" + i + "] == null");
                }
                if (cur.length == M) continue;
                throw new IllegalArgumentException("matrix[" + i + "].length != matrix[0].length");
            }
        }
    }

    public static StringBuilder start(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getSimpleName());
        sb.append('[');
        return sb;
    }

    public static String finish(StringBuilder sb) {
        return sb.append(']').toString();
    }

    public static void firstObj(StringBuilder sb, String name, Object obj) {
        sb.append(name);
        sb.append('=');
        sb.append(obj);
    }

    public static void addObj(StringBuilder sb, String name, Object obj) {
        sb.append(", ");
        ToStringUtil.firstObj(sb, name, obj);
    }

    public static void addObj(StringBuilder sb, Object obj) {
        sb.append(", ");
        sb.append(obj);
    }

    public static void firstInt(StringBuilder sb, String name, int v) {
        sb.append(name);
        sb.append('=');
        sb.append(v);
    }

    public static void addInt(StringBuilder sb, String name, int v) {
        sb.append(", ");
        ToStringUtil.firstInt(sb, name, v);
    }

    public static void addInt(StringBuilder sb, int v) {
        sb.append(", ");
        sb.append(v);
    }

    public static void firstLong(StringBuilder sb, String name, long v) {
        sb.append(name);
        sb.append('=');
        sb.append(v);
    }

    public static void addLong(StringBuilder sb, String name, long v) {
        sb.append(", ");
        ToStringUtil.firstLong(sb, name, v);
    }

    public static void addLong(StringBuilder sb, long v) {
        sb.append(", ");
        sb.append(v);
    }

    public static void firstStr(StringBuilder sb, String name, String v) {
        sb.append(name);
        sb.append('=');
        sb.append(v);
    }

    public static void addStr(StringBuilder sb, String name, String v) {
        sb.append(", ");
        ToStringUtil.firstStr(sb, name, v);
    }

    public static void addStr(StringBuilder sb, String v) {
        sb.append(", ");
        sb.append(v);
    }
}

