/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.LongPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;

public final class StaticLongMap<T> {
    private final long[] keys;
    private final Object[] values;

    private StaticLongMap(long[] keys, Object[] values) {
        this.keys = keys;
        this.values = values;
    }

    public static <T> StaticLongMap<T> create(Collection<LongPair<T>> elements) {
        if (elements == null || elements.isEmpty()) {
            throw new IllegalArgumentException("null or empty collection provided");
        }
        int l = elements.size();
        LongPair[] elems = new LongPair[l];
        elems = elements.toArray(elems);
        return StaticLongMap.init(elems);
    }

    public static <T> StaticLongMap<T> create(LongPair<T> ... elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("null or empty collection provided");
        }
        elements = (LongPair[])elements.clone();
        return StaticLongMap.init(elements);
    }

    private static <T> StaticLongMap<T> init(LongPair<?>[] elements) {
        int len = elements.length;
        Arrays.sort(elements, LongPair.KEY_COMPARATOR);
        long[] keys = new long[len];
        Object[] values = new Object[len];
        long prevKey = 0L;
        for (int i = 0; i < len; ++i) {
            LongPair<?> elem = elements[i];
            long key = elem.getKey();
            Object value = elem.getValue();
            if (i > 0 && prevKey == key) {
                throw new IllegalArgumentException("duplicate key: " + key);
            }
            prevKey = key;
            keys[i] = key;
            values[i] = value;
        }
        return new StaticLongMap<T>(keys, values);
    }

    public T get(long key) {
        int idx = Arrays.binarySearch(this.keys, key);
        return (T)(idx < 0 ? null : this.values[idx]);
    }

    public T getOrElse(long key, T defaultVal) {
        int idx = Arrays.binarySearch(this.keys, key);
        return (T)(idx < 0 ? defaultVal : this.values[idx]);
    }

    public T getOrThrow(long key) throws NoSuchElementException {
        int idx = Arrays.binarySearch(this.keys, key);
        if (idx < 0) {
            throw new NoSuchElementException("no value found for key: " + key);
        }
        return (T)this.values[idx];
    }

    public boolean containsKey(long key) {
        return Arrays.binarySearch(this.keys, key) >= 0;
    }

    public int size() {
        return this.keys.length;
    }
}

