/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache.buffercache.impl;

import ch.bind.philib.cache.buffercache.CacheStats;
import ch.bind.philib.cache.buffercache.ObjectCache;
import ch.bind.philib.cache.buffercache.impl.ObjectFactory;
import ch.bind.philib.cache.buffercache.impl.SimpleCacheStats;
import ch.bind.philib.validation.Validation;

public abstract class ObjectCacheBase<E>
implements ObjectCache<E> {
    private final ObjectFactory<E> factory;
    private final SimpleCacheStats stats = new SimpleCacheStats();

    public ObjectCacheBase(ObjectFactory<E> factory) {
        Validation.notNull(factory);
        this.factory = factory;
    }

    @Override
    public final E acquire() {
        this.stats.incrementAcquires();
        while (true) {
            E e;
            if ((e = this.tryAcquire()) == null) {
                this.stats.incrementCreates();
                return this.factory.create();
            }
            if (this.factory.canReuse(e)) {
                return e;
            }
            this.stats.incrementDestroyed();
            this.factory.destroy(e);
        }
    }

    @Override
    public final void release(E e) {
        if (e != null) {
            if (this.factory.prepareForReuse(e) && this.tryRelease(e)) {
                this.stats.incrementReleases();
                return;
            }
            this.stats.incrementDestroyed();
            this.factory.destroy(e);
        }
    }

    @Override
    public final CacheStats getCacheStats() {
        return this.stats;
    }

    protected abstract E tryAcquire();

    protected abstract boolean tryRelease(E var1);
}

