/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache.lru;

import ch.bind.philib.cache.lru.Cache;
import ch.bind.philib.validation.Validation;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class SyncCache<K, V>
implements Cache<K, V> {
    private final Lock lock = new ReentrantLock();
    private final Cache<K, V> cache;

    public SyncCache(Cache<K, V> cache) {
        Validation.notNull(cache);
        this.cache = cache;
    }

    public static final <K, V> Cache<K, V> wrap(Cache<K, V> cache) {
        return new SyncCache<K, V>(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(K key, V value) {
        this.lock.lock();
        try {
            this.cache.add(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.lock.lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        this.lock.lock();
        try {
            this.cache.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        return this.cache.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

