/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import java.nio.ByteBuffer;
import java.util.Random;

public abstract class ArrayUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Random rand = new Random();
    private static final char[] TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    protected ArrayUtil() {
    }

    public static <T> void pickRandom(T[] source, T[] destination) {
        if (source == null) {
            throw new NullPointerException("the source array must not be null");
        }
        if (destination == null) {
            throw new NullPointerException("the destination array must not be null");
        }
        int nSrc = source.length;
        int nDst = destination.length;
        if (nSrc < nDst) {
            throw new IllegalArgumentException("the source arrays length must be greater or equal to the destination arrays length");
        }
        boolean[] taken = new boolean[nSrc];
        for (int i = 0; i < nDst; ++i) {
            int idx = rand.nextInt(nSrc);
            while (taken[idx]) {
                idx = rand.nextInt(nSrc);
            }
            taken[idx] = true;
            destination[i] = source[idx];
        }
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (a == null) {
            a = EMPTY_BYTE_ARRAY;
        }
        if (b == null) {
            b = EMPTY_BYTE_ARRAY;
        }
        int len = a.length + b.length;
        byte[] c = new byte[len];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] extractBack(byte[] data, int len) {
        byte[] rv = new byte[len];
        int offset = data.length - len;
        System.arraycopy(data, offset, rv, 0, len);
        return rv;
    }

    public static byte[] extractFront(byte[] data, int len) {
        byte[] rv = new byte[len];
        System.arraycopy(data, 0, rv, 0, len);
        return rv;
    }

    public static String formatShortHex(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        return ArrayUtil.formatShortHex(data, 0, data.length);
    }

    public static String formatShortHex(byte[] data, int off, int len) {
        int idx;
        if (data == null) {
            return "";
        }
        int l = data.length;
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len && (idx = off + i) < l; ++i) {
            ArrayUtil.toShortHex(sb, data[idx] & 0xFF);
        }
        return sb.toString();
    }

    public static String formatShortHex(ByteBuffer data) {
        if (data == null) {
            return "";
        }
        int len = data.remaining();
        if (len == 0) {
            return "";
        }
        if (data.hasArray()) {
            return ArrayUtil.formatShortHex(data.array(), data.position(), len);
        }
        StringBuilder sb = new StringBuilder(len * 2);
        int initialPos = data.position();
        for (int i = 0; i < len; ++i) {
            ArrayUtil.toShortHex(sb, data.get() & 0xFF);
        }
        data.position(initialPos);
        return sb.toString();
    }

    private static void toShortHex(StringBuilder sb, int v) {
        assert (v >= 0 && v < 256);
        if (v < 16) {
            sb.append('0');
        } else {
            sb.append(TO_HEX[v >>> 4]);
        }
        sb.append(TO_HEX[v & 0xF]);
    }
}

