/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache.buffercache.impl;

import ch.bind.philib.cache.buffercache.CacheStats;

public final class CombinedCacheStats
implements CacheStats {
    private CacheStats[] stats;

    CombinedCacheStats(CacheStats[] stats) {
        this.stats = stats;
    }

    @Override
    public long getAcquires() {
        long a = 0L;
        for (CacheStats s : this.stats) {
            a += s.getAcquires();
        }
        return a;
    }

    @Override
    public long getCreates() {
        long c = 0L;
        for (CacheStats s : this.stats) {
            c += s.getCreates();
        }
        return c;
    }

    @Override
    public long getReleases() {
        long r = 0L;
        for (CacheStats s : this.stats) {
            r += s.getReleases();
        }
        return r;
    }

    @Override
    public long getDestroyed() {
        long d = 0L;
        for (CacheStats s : this.stats) {
            d += s.getDestroyed();
        }
        return d;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("cache-total: acquires=");
        sb.append(this.getAcquires());
        sb.append(", creates=");
        sb.append(this.getCreates());
        sb.append(", releases=");
        sb.append(this.getReleases());
        sb.append(", destroyed=");
        sb.append(this.getDestroyed());
        for (int i = 0; i < this.stats.length; ++i) {
            sb.append("\n");
            sb.append("  bucket-");
            sb.append(i);
            sb.append(": ");
            sb.append(this.stats[i]);
        }
        return sb.toString();
    }
}

