/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache.lru;

import ch.bind.philib.cache.lru.Cache;
import ch.bind.philib.cache.lru.Cloner;
import ch.bind.philib.cache.lru.SimpleCacheEntry;
import ch.bind.philib.util.ClusteredHashIndex;
import ch.bind.philib.util.ClusteredIndex;
import ch.bind.philib.util.LruList;
import ch.bind.philib.validation.Validation;

public final class SimpleCache<K, V>
implements Cache<K, V> {
    public static final int MIN_CACHE_CAPACITY = 8;
    private final LruList<SimpleCacheEntry<K, V>> lru;
    private final ClusteredIndex<K, SimpleCacheEntry<K, V>> index;
    private final Cloner<V> cloner;

    public SimpleCache() {
        this(256);
    }

    public SimpleCache(int capacity) {
        this(capacity, null);
    }

    public SimpleCache(int capacity, Cloner<V> cloner) {
        capacity = Math.max(8, capacity);
        this.lru = new LruList(capacity);
        this.index = new ClusteredHashIndex<K, SimpleCacheEntry<K, V>>(capacity);
        this.cloner = cloner;
    }

    @Override
    public void add(K key, V value) {
        Validation.notNull(key);
        SimpleCacheEntry<K, V> entry = this.index.get(key);
        if (value == null) {
            if (entry != null) {
                this.removeLruAndIndex(entry);
            }
            return;
        }
        if (entry == null) {
            entry = new SimpleCacheEntry<K, V>(key, value);
            this.index.add(entry);
            SimpleCacheEntry<K, V> removed = this.lru.add(entry);
            if (removed != null) {
                this.index.remove(removed);
            }
        } else {
            entry.setValue(value);
        }
    }

    @Override
    public V get(K key) {
        Validation.notNull(key);
        SimpleCacheEntry<K, V> entry = this.index.get(key);
        if (entry == null) {
            return null;
        }
        V value = entry.getValue();
        if (value == null) {
            this.removeLruAndIndex(entry);
            return null;
        }
        this.lru.moveToHead(entry);
        return this.cloner == null ? value : this.cloner.cloneValue(value);
    }

    @Override
    public void remove(K key) {
        Validation.notNull(key);
        this.removeLruAndIndex(this.index.get(key));
    }

    @Override
    public int capacity() {
        return this.lru.capacity();
    }

    @Override
    public void clear() {
        this.lru.clear();
        this.index.clear();
    }

    private void removeLruAndIndex(SimpleCacheEntry<K, V> entry) {
        if (entry != null) {
            this.index.remove(entry);
            this.lru.remove(entry);
        }
    }
}

