/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.ClusteredIndex;
import java.util.Arrays;

public final class ClusteredHashIndex<K, T extends ClusteredIndex.Entry<K>>
implements ClusteredIndex<K, T> {
    private final ClusteredIndex.Entry<K>[] table;

    public ClusteredHashIndex(int capacity) {
        this.table = new ClusteredIndex.Entry[capacity];
    }

    @Override
    public boolean add(T entry) {
        assert (entry != null && entry.getNextIndexEntry() == null && entry.getKey() != null);
        Object key = entry.getKey();
        int hash = key.hashCode();
        int position = this.hashPosition(hash);
        ClusteredIndex.Entry<K> scanNow = this.table[position];
        if (scanNow == null) {
            this.table[position] = entry;
            return true;
        }
        ClusteredIndex.Entry<K> scanPrev = null;
        do {
            K nowKey;
            if (hash == (nowKey = scanNow.getKey()).hashCode() && key.equals(nowKey)) {
                return false;
            }
            scanPrev = scanNow;
        } while ((scanNow = scanNow.getNextIndexEntry()) != null);
        assert (scanPrev != null);
        scanPrev.setNextIndexEntry((ClusteredIndex.Entry<K>)entry);
        return true;
    }

    @Override
    public boolean remove(T entry) {
        ClusteredIndex.Entry<K> scanNow;
        assert (entry != null);
        Object key = entry.getKey();
        int hash = key.hashCode();
        int position = this.hashPosition(hash);
        ClusteredIndex.Entry<K> scanPrev = null;
        for (scanNow = this.table[position]; scanNow != null && scanNow != entry; scanNow = scanNow.getNextIndexEntry()) {
            scanPrev = scanNow;
        }
        if (scanNow != null) {
            assert (hash == scanNow.getKey().hashCode() && key.equals(scanNow.getKey()));
            if (scanPrev == null) {
                this.table[position] = scanNow.getNextIndexEntry();
            } else {
                scanPrev.setNextIndexEntry(scanNow.getNextIndexEntry());
            }
            return true;
        }
        return false;
    }

    @Override
    public T get(K key) {
        assert (key != null);
        int hash = key.hashCode();
        int position = this.hashPosition(hash);
        for (ClusteredIndex.Entry<K> entry = this.table[position]; entry != null; entry = entry.getNextIndexEntry()) {
            K entryKey = entry.getKey();
            if (hash != entryKey.hashCode() || !key.equals(entryKey)) continue;
            return (T)entry;
        }
        return null;
    }

    private int hashPosition(int hash) {
        int p = hash % this.table.length;
        return Math.abs(p);
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
    }
}

