/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.LruNode;
import ch.bind.philib.validation.Validation;

public final class LruList<E extends LruNode> {
    private final int capacity;
    private E head;
    private E tail;
    private int size;

    public LruList(int capacity) {
        Validation.isTrue(capacity > 0, "capacity must be > 0");
        this.capacity = capacity;
    }

    public E add(E node) {
        assert (node.getLruPrev() == null && node.getLruNext() == null);
        if (this.head == null) {
            assert (this.tail == null);
            this.head = node;
            this.tail = node;
        } else {
            assert (this.tail != null);
            node.setLruNext((LruNode)this.head);
            this.head.setLruPrev((LruNode)node);
            this.head = node;
        }
        ++this.size;
        if (this.size <= this.capacity) {
            return null;
        }
        return this.removeTail();
    }

    public void remove(E node) {
        assert (this.head != null && this.tail != null);
        LruNode prev = node.getLruPrev();
        LruNode next = node.getLruNext();
        if (this.head == node) {
            if (this.tail == node) {
                assert (next == null && prev == null);
                this.head = null;
                this.tail = null;
            } else {
                assert (prev == null && next.getLruPrev() == node);
                next.setLruPrev(null);
                this.head = next;
            }
        } else if (this.tail == node) {
            assert (next == null && prev.getLruNext() == node);
            prev.setLruNext(null);
            this.tail = prev;
        } else {
            assert (prev != null && next != null && prev.getLruNext() == node && next.getLruPrev() == node);
            prev.setLruNext(next);
            next.setLruPrev(prev);
        }
        --this.size;
        node.resetLruNode();
    }

    public E removeTail() {
        if (this.tail == null) {
            return null;
        }
        E node = this.tail;
        if (this.head == node) {
            this.tail = null;
            this.head = null;
            this.size = 0;
        } else {
            LruNode prev = node.getLruPrev();
            prev.setLruNext(null);
            this.tail = prev;
            --this.size;
        }
        node.resetLruNode();
        return node;
    }

    public void moveToHead(E node) {
        assert (this.head != null && this.tail != null);
        if (this.head == node) {
            return;
        }
        LruNode prev = node.getLruPrev();
        LruNode next = node.getLruNext();
        if (this.tail == node) {
            assert (prev != null && next == null && prev.getLruNext() == node);
            node.setLruPrev(null);
            prev.setLruNext(null);
            this.head.setLruPrev((LruNode)node);
            node.setLruNext((LruNode)this.head);
            this.head = node;
            this.tail = prev;
        } else {
            assert (prev != null && next != null && prev.getLruNext() == node && next.getLruPrev() == node);
            prev.setLruNext(next);
            next.setLruPrev(prev);
            node.setLruNext((LruNode)this.head);
            node.setLruPrev(null);
            this.head.setLruPrev((LruNode)node);
            this.head = node;
        }
    }

    public void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean hasSpace() {
        return this.size < this.capacity;
    }
}

