/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.LoadAvg;
import ch.bind.philib.validation.Validation;

public final class LoadAvgSimple
implements LoadAvg {
    private final long lAvgOfXNs;
    private final double fAvgOfXNs;
    private long tWork;
    private long tIdle;
    private long lastNormalizeNs;

    private LoadAvgSimple(long avgOfXNs) {
        this.lAvgOfXNs = avgOfXNs;
        this.fAvgOfXNs = avgOfXNs;
        this.tIdle = avgOfXNs;
    }

    public static LoadAvgSimple forSeconds(int secs) {
        Validation.isTrue(secs >= 1);
        return new LoadAvgSimple((long)secs * 1000000000L);
    }

    public static LoadAvgSimple forMillis(int millis) {
        Validation.isTrue(millis >= 1);
        return new LoadAvgSimple((long)millis * 1000000L);
    }

    public static LoadAvgSimple forMicros(int micros) {
        Validation.isTrue(micros >= 1);
        return new LoadAvgSimple((long)micros * 1000L);
    }

    public static LoadAvgSimple forNanos(int nanos) {
        Validation.isTrue(nanos >= 1);
        return new LoadAvgSimple(nanos);
    }

    @Override
    public long logWorkMs(long workMs) {
        return this.logWorkNs(workMs * 1000000L);
    }

    @Override
    public long logWorkNs(long workNs) {
        return this.logWorkNs(System.nanoTime(), workNs);
    }

    long logWorkNs(long nowNs, long workNs) {
        long diff;
        if (this.lastNormalizeNs == 0L) {
            diff = this.lAvgOfXNs;
        } else {
            diff = nowNs - this.lastNormalizeNs;
            if (diff < 0L) {
                diff = 0L;
            }
        }
        this.lastNormalizeNs = nowNs;
        this.tWork += workNs;
        this.tIdle += Math.max(0L, diff - workNs);
        long total = this.tIdle + this.tWork;
        double factor = this.fAvgOfXNs / (double)total;
        this.tIdle = (long)((double)this.tIdle * factor);
        this.tWork = (long)((double)this.tWork * factor);
        return this.tWork;
    }

    @Override
    public long getLoadAvg() {
        return this.logWorkNs(System.nanoTime(), 0L);
    }

    @Override
    public double asFactor(long loadAvg) {
        return (double)loadAvg / this.fAvgOfXNs;
    }
}

