/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.validation.Validation;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class LimitedConcurrentQueue<T> {
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger size = new AtomicInteger();
    private final int capacity;

    public LimitedConcurrentQueue(int limit) {
        Validation.isTrue(limit > 0);
        this.capacity = limit;
    }

    public T poll() {
        T value = this.queue.poll();
        if (value != null) {
            this.size.decrementAndGet();
        }
        return value;
    }

    public boolean offer(T value) {
        int s;
        do {
            if ((s = this.size.get()) < this.capacity) continue;
            return false;
        } while (!this.size.compareAndSet(s, s + 1));
        return this.queue.offer(value);
    }

    public int size() {
        return this.size.get();
    }

    public int getLimit() {
        return this.capacity;
    }
}

