/*
 * Copyright (c) 2013 Philipp Meinen <philipp@bind.ch>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the Software
 * is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
 * THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package ch.bind.philib.msg.vm;

import java.util.Map;

import ch.bind.philib.msg.MessageHandler;
import ch.bind.philib.msg.Subscription;

public interface PubSub {

	Subscription subscribe(String channelName, MessageHandler handler);

	Subscription forward(String fromChannelName, String toChannelName);
	
	Subscription forward(PubSub pubsub, String fromChannelName, String toChannelName);

	void publishSync(String channelName, Object message);

	void publishAsync(String channelName, Object message);
	
	/**
	 * Lists all channels with one or more subscriptions.
	 * @return a {@link Map} with active channel names as key and the number of subscribers as value. 
	 */
	Map<String, Integer> activeChannels();
}
