/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.lang.CompareUtil;
import ch.bind.philib.util.TLR;
import ch.bind.philib.validation.Validation;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Random;

public abstract class ArrayUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final char[] TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static volatile byte[] nullFiller;

    protected ArrayUtil() {
    }

    public static <T> T[] newArray(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    public static <T> void pickRandom(T[] source, T[] destination) {
        if (source == null) {
            throw new NullPointerException("the source array must not be null");
        }
        if (destination == null) {
            throw new NullPointerException("the destination array must not be null");
        }
        int nSrc = source.length;
        int nDst = destination.length;
        if (nSrc < nDst) {
            throw new IllegalArgumentException("the source arrays length must be greater or equal to the destination arrays length");
        }
        Random rand = TLR.current();
        boolean[] taken = new boolean[nSrc];
        for (int i = 0; i < nDst; ++i) {
            int idx = rand.nextInt(nSrc);
            while (taken[idx]) {
                idx = rand.nextInt(nSrc);
            }
            taken[idx] = true;
            destination[i] = source[idx];
        }
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (a == null) {
            a = EMPTY_BYTE_ARRAY;
        }
        if (b == null) {
            b = EMPTY_BYTE_ARRAY;
        }
        int la = a.length;
        int lb = b.length;
        int len = la + lb;
        byte[] rv = new byte[len];
        System.arraycopy(a, 0, rv, 0, la);
        System.arraycopy(b, 0, rv, la, lb);
        return rv;
    }

    public static byte[] append(byte[] a, byte[] b, int capacity) {
        if (capacity <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (a == null) {
            a = EMPTY_BYTE_ARRAY;
        }
        if (b == null) {
            b = EMPTY_BYTE_ARRAY;
        }
        int la = a.length;
        int lb = b.length;
        int len = la + lb;
        len = Math.min(len, capacity);
        byte[] rv = new byte[len];
        if (la >= capacity) {
            System.arraycopy(a, 0, rv, 0, capacity);
        } else {
            System.arraycopy(a, 0, rv, 0, la);
            int fromB = Math.min(capacity - la, lb);
            System.arraycopy(b, 0, rv, la, fromB);
        }
        return rv;
    }

    public static <T> T[] append(Class<T> clazz, T[] a, T b) {
        Validation.notNull(clazz);
        Validation.notNull(b);
        if (a == null) {
            T[] ts = ArrayUtil.newArray(clazz, 1);
            ts[0] = b;
            return ts;
        }
        int l = a.length;
        T[] ts = ArrayUtil.newArray(clazz, l + 1);
        System.arraycopy(a, 0, ts, 0, l);
        ts[l] = b;
        return ts;
    }

    public static <T> T[] remove(Class<T> clazz, T[] from, T what) {
        Validation.notNull(clazz);
        Validation.notNull(from);
        int l = from.length;
        int num = 0;
        for (int i = 0; i < l; ++i) {
            if (!CompareUtil.equals(from[i], what)) continue;
            ++num;
        }
        if (num == 0) {
            return from;
        }
        int newLen = l - num;
        T[] to = ArrayUtil.newArray(clazz, newLen);
        if (newLen == 0) {
            return to;
        }
        int j = 0;
        for (int i = 0; i < l; ++i) {
            if (CompareUtil.equals(from[i], what)) continue;
            to[j++] = from[i];
        }
        return to;
    }

    public static byte[] extractBack(byte[] data, int len) {
        byte[] rv = new byte[len];
        int offset = data.length - len;
        System.arraycopy(data, offset, rv, 0, len);
        return rv;
    }

    public static byte[] extractFront(byte[] data, int len) {
        byte[] rv = new byte[len];
        System.arraycopy(data, 0, rv, 0, len);
        return rv;
    }

    public static boolean contains(byte[] data, byte[] search) {
        return ArrayUtil.find(data, search, 0) >= 0;
    }

    public static int find(byte[] data, byte[] search) {
        return ArrayUtil.find(data, search, 0);
    }

    public static int find(byte[] data, byte[] search, int dataOffset) {
        if (data == null || search == null) {
            return -1;
        }
        int searchLen = search.length;
        int dataLen = data.length;
        int maxLoops = dataLen - dataOffset - searchLen + 1;
        if (dataLen == 0 || searchLen == 0 || maxLoops < 1) {
            return -1;
        }
        block0: for (int i = 0; i < maxLoops; ++i) {
            int off = dataOffset + i;
            for (int j = 0; j < searchLen; ++j) {
                if (data[off + j] != search[j]) continue block0;
            }
            return off;
        }
        return -1;
    }

    public static String formatShortHex(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        return ArrayUtil.formatShortHex(data, 0, data.length);
    }

    public static String formatShortHex(byte[] data, int off, int len) {
        int idx;
        if (data == null || data.length == 0) {
            return "";
        }
        int l = data.length;
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len && (idx = off + i) < l; ++i) {
            ArrayUtil.toShortHex(sb, data[idx] & 0xFF);
        }
        return sb.toString();
    }

    public static String formatShortHex(ByteBuffer data, int len) {
        int printLen;
        if (data == null) {
            return "";
        }
        int dataLen = data.remaining();
        if (dataLen == 0) {
            return "";
        }
        int n = printLen = len == -1 ? dataLen : Math.min(dataLen, len);
        if (data.hasArray()) {
            return ArrayUtil.formatShortHex(data.array(), data.position(), printLen);
        }
        StringBuilder sb = new StringBuilder(printLen * 2);
        int initialPos = data.position();
        for (int i = 0; i < printLen; ++i) {
            ArrayUtil.toShortHex(sb, data.get() & 0xFF);
        }
        data.position(initialPos);
        return sb.toString();
    }

    public static String formatShortHex(ByteBuffer data) {
        return ArrayUtil.formatShortHex(data, -1);
    }

    private static void toShortHex(StringBuilder sb, int v) {
        assert (v >= 0 && v < 256);
        if (v < 16) {
            sb.append('0');
        } else {
            sb.append(TO_HEX[v >>> 4]);
        }
        sb.append(TO_HEX[v & 0xF]);
    }

    public static void memclr(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        if (buf.hasArray()) {
            ArrayUtil.memclr(buf.array());
        } else {
            int l;
            byte[] filler = ArrayUtil.getFiller();
            int filLen = filler.length;
            buf.clear();
            for (int rem = buf.capacity(); rem > 0; rem -= l) {
                l = Math.min(rem, filLen);
                buf.put(filler, 0, l);
            }
        }
        buf.clear();
    }

    public static void memclr(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return;
        }
        byte[] filler = ArrayUtil.getFiller();
        int filLen = filler.length;
        int rem = buf.length;
        int off = 0;
        while (rem > 0) {
            int l = Math.min(rem, filLen);
            ArrayUtil.memset(filler, buf, off, l);
            rem -= l;
            off += l;
        }
    }

    private static final void memset(byte[] src, byte[] dst, int dstOff, int len) {
        System.arraycopy(src, 0, dst, dstOff, len);
    }

    private static byte[] getFiller() {
        byte[] f = nullFiller;
        if (f == null) {
            nullFiller = f = new byte[8192];
        }
        return f;
    }
}

