/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.object;

import ch.bind.philib.pool.Pool;
import ch.bind.philib.pool.PoolStats;
import ch.bind.philib.pool.manager.ObjectManager;
import ch.bind.philib.pool.object.SimplePoolStats;
import ch.bind.philib.validation.Validation;

public abstract class PoolBase<T>
implements Pool<T> {
    private final ObjectManager<T> manager;
    private final SimplePoolStats stats = new SimplePoolStats();

    public PoolBase(ObjectManager<T> manager) {
        Validation.notNull(manager);
        this.manager = manager;
    }

    @Override
    public final T take() {
        this.stats.incrementTakes();
        while (true) {
            T e;
            if ((e = this.poll()) == null) {
                this.stats.incrementCreates();
                return this.manager.create();
            }
            if (this.manager.canReuse(e)) {
                return e;
            }
            this.stats.incrementReleased();
            this.manager.release(e);
        }
    }

    @Override
    public final void recycle(T value) {
        if (value != null) {
            if (this.manager.prepareForRecycle(value) && this.offer(value)) {
                this.stats.incrementRecycled();
                return;
            }
            this.stats.incrementReleased();
            this.manager.release(value);
        }
    }

    @Override
    public final void clear() {
        Object e = null;
        while (true) {
            T t = this.poll();
            e = t;
            if (t == null) break;
            this.stats.incrementReleased();
            this.manager.release(e);
        }
    }

    @Override
    public final PoolStats getPoolStats() {
        return this.stats;
    }

    protected abstract T poll();

    protected abstract boolean offer(T var1);
}

