/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.math;

public abstract class Calc {
    protected Calc() {
    }

    public static long ceilDiv(long num, long divisor) {
        assert (num > 0L && divisor > 0L);
        return (num - 1L) / divisor + 1L;
    }

    public static int ceilDiv(int num, int divisor) {
        assert (num > 0 && divisor > 0);
        return (num - 1) / divisor + 1;
    }

    public static long unsignedAdd(long a, long b) {
        long r = a + b;
        return Calc.isAddUnderOrOverflow(a, b, r) ? Long.MAX_VALUE : r;
    }

    public static boolean isAddUnderOrOverflow(long a, long b, long r) {
        return ((a ^ r) & (b ^ r)) < 0L;
    }

    public static long sumOfRange(long end) {
        if (end < 1L) {
            return 0L;
        }
        return end * (end + 1L) / 2L;
    }

    public static long sumOfRange(long start, long end) {
        if (start > end) {
            return 0L;
        }
        return Calc.sumOfRange(end) - Calc.sumOfRange(start - 1L);
    }

    public static int clip(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static long clip(long value, long min, long max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clip(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }
}

