/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.ecc;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.ecc.S256Field;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.ecc.Signature;
import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Helper;
import javax.crypto.Mac;

public class PrivateKey {
    private final Int secret;
    private final S256Point point;

    public PrivateKey(Int secret) {
        this.secret = secret;
        this.point = S256Point.getG().mul(secret);
    }

    public Signature sign(Int z) {
        Int k = this.deterministicK(z);
        Int r = ((S256Field)S256Point.getG().mul((Int)k).getX()).num;
        Int kInv = k.powMod(S256Point.N.sub(Int.parse(2)), S256Point.N);
        Int s = r.mul(this.secret).add(z).mul(kInv).mod(S256Point.N);
        if (s.gt(S256Point.N.div(Int.parse(2)))) {
            s = S256Point.N.sub(s);
        }
        return new Signature(r, s);
    }

    public Int deterministicK(Int z) {
        byte[] k = Bytes.initFill(32, (byte)0);
        byte[] v = Bytes.initFill(32, (byte)1);
        byte[] secretBytes = this.secret.toBytes(32);
        byte[] zBytes = z.toBytes(32);
        if (z.gt(S256Point.N)) {
            zBytes = z.sub(S256Point.N).toBytes(32);
        }
        Mac hmac = Helper.hmacS256Init(k);
        hmac.update(v);
        hmac.update(new byte[]{0});
        hmac.update(secretBytes);
        k = hmac.doFinal(zBytes);
        hmac = Helper.hmacS256Init(k);
        v = hmac.doFinal(v);
        hmac = Helper.hmacS256Init(k);
        hmac.update(v);
        hmac.update(new byte[]{1});
        hmac.update(secretBytes);
        k = hmac.doFinal(zBytes);
        hmac = Helper.hmacS256Init(k);
        v = hmac.doFinal(v);
        Int one = Int.parse(1);
        Hex candidate;
        while (!(candidate = Hex.parse(v = (hmac = Helper.hmacS256Init(k)).doFinal(v))).ge(one) || !candidate.lt(S256Point.N)) {
            hmac = Helper.hmacS256Init(k);
            hmac.update(v);
            k = hmac.doFinal(new byte[]{0});
            hmac = Helper.hmacS256Init(k);
            v = hmac.doFinal(v);
        }
        return candidate;
    }

    public String wif(boolean compressed, boolean testnet) {
        byte[] secretBytes = this.secret.toBytes(32);
        byte prefix = testnet ? (byte)-17 : -128;
        if (compressed) {
            return Base58.encodeChecksum(Bytes.add(new byte[][]{{prefix}, secretBytes, {1}}));
        }
        return Base58.encodeChecksum(Bytes.add(new byte[]{prefix}, secretBytes));
    }

    public S256Point getPoint() {
        return this.point;
    }
}

