/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.network.Message;
import ch.bitagent.bitcoin.lib.network.NetworkEnvelope;
import ch.bitagent.bitcoin.lib.network.PongMessage;
import ch.bitagent.bitcoin.lib.network.VerAckMessage;
import ch.bitagent.bitcoin.lib.network.VersionMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class SimpleNode {
    private static final Logger log = Logger.getLogger(SimpleNode.class.getSimpleName());
    private final String host;
    private final Integer port;
    private final Boolean testnet;
    private final boolean logging;
    private final SocketChannel socketChannel;

    public SimpleNode(String host, Integer port, Boolean testnet, Boolean logging) {
        this.host = Objects.requireNonNullElse(host, "localhost");
        this.port = Objects.requireNonNullElseGet(port, () -> {
            if (Boolean.TRUE.equals(testnet)) {
                return 18333;
            }
            return 8333;
        });
        this.testnet = Objects.requireNonNullElse(testnet, false);
        this.logging = Objects.requireNonNullElse(logging, false);
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(true);
            this.socketChannel.connect(new InetSocketAddress(this.host, (int)this.port));
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            log.severe(e.getMessage());
        }
    }

    public byte[] handshake() {
        VersionMessage version = new VersionMessage();
        this.send(version);
        NetworkEnvelope envelope = this.waitFor(Set.of("verack", "sendcmpct"));
        if (envelope == null) {
            log.severe("no verack or sendcmpct");
            return new byte[0];
        }
        return envelope.getPayload();
    }

    public void send(Message message) {
        NetworkEnvelope envelope = new NetworkEnvelope(message.getCommand(), message.serialize(), this.testnet);
        if (this.logging) {
            log.info(String.format("sending %s", envelope));
        }
        try {
            this.socketChannel.write(ByteBuffer.wrap(envelope.serialize()));
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public NetworkEnvelope read() {
        try {
            long start = System.currentTimeMillis();
            log.fine("start ...");
            ByteBuffer buffer = ByteBuffer.allocate(262144);
            int currentLength = 0;
            int expectedLength = -1;
            do {
                try {
                }
                catch (IOException e) {
                    log.severe(e.getMessage());
                    return null;
                }
                if ((currentLength += this.socketChannel.read(buffer)) > 0) {
                    expectedLength = NetworkEnvelope.parseLength(new ByteArrayInputStream(buffer.array()));
                }
                if (currentLength >= 0) continue;
                log.warning(String.format("no data - currentLength %s < 0, expectedLength %s", currentLength, expectedLength));
                return null;
            } while (currentLength < expectedLength);
            log.fine(String.format("data read - currentLength %s >= expectedLength %s", currentLength, expectedLength));
            if (buffer.remaining() < 16384) {
                log.warning(String.format("buffer to small with remaining %s", buffer.remaining()));
            }
            NetworkEnvelope envelope = NetworkEnvelope.parse(new ByteArrayInputStream(buffer.array()), this.testnet);
            if (this.logging) {
                log.fine(String.format("receiving %s", Bytes.byteArrayToString(envelope.getCommand())));
            }
            log.fine(String.format("in %sms.", System.currentTimeMillis() - start));
            return envelope;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public NetworkEnvelope waitFor(Set<String> commands) {
        try {
            log.fine(String.format("%s ...", String.join((CharSequence)", ", commands)));
            String command = "";
            NetworkEnvelope envelope = null;
            while (!commands.contains(command) && (envelope = this.read()) != null) {
                command = Bytes.byteArrayToString(envelope.getCommand());
                if (envelope.isCommand("version")) {
                    this.send(new VerAckMessage());
                    continue;
                }
                if (envelope.isCommand("ping")) {
                    this.send(new PongMessage(envelope.getPayload()));
                    continue;
                }
                if (commands.contains(command)) {
                    log.fine(String.format("got %s", command));
                    continue;
                }
                log.warning(String.format("got %s unexpected", command));
            }
            if (envelope != null) {
                if (this.logging) {
                    log.info(String.format("return %s", Bytes.byteArrayToString(envelope.getCommand())));
                }
                return envelope;
            }
            return null;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }
}

