/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.tx;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Helper;
import ch.bitagent.bitcoin.lib.helper.Http;
import ch.bitagent.bitcoin.lib.helper.Properties;
import ch.bitagent.bitcoin.lib.tx.Tx;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class TxFetcher {
    private static final Logger log = Logger.getLogger(TxFetcher.class.getSimpleName());
    private static Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private static final String CACHE_FILE = Properties.getTxCachefile();

    private TxFetcher() {
    }

    public static Tx fetch(String txId, Boolean testnet, boolean fresh) {
        byte[] txBytes;
        ByteArrayInputStream txStream;
        Tx tx;
        String computed;
        String txId64 = Helper.zfill64(txId);
        boolean doFresh = fresh || Properties.getTxFresh() != false;
        TxFetcher.loadCache(doFresh);
        if (doFresh || !cache.containsKey(txId64)) {
            long start = System.currentTimeMillis();
            try {
                Tx tx2;
                String txRaw = Properties.getBitcoinRpcAuth() != null && Properties.getBitcoinRpcTestnet().equals(testnet) ? Http.postGetRawTransaction(txId64) : Http.get(TxFetcher.getUrlBlockstream(testnet, txId64));
                byte[] rawBytes = Bytes.hexStringToByteArray(txRaw);
                if (rawBytes[4] == 0) {
                    rawBytes = Bytes.add(Arrays.copyOfRange(rawBytes, 0, 4), Arrays.copyOfRange(rawBytes, 6, rawBytes.length));
                    tx2 = Tx.parse(new ByteArrayInputStream(rawBytes), testnet);
                    Hex locktime = Hex.parse(Bytes.changeOrder(Arrays.copyOfRange(rawBytes, rawBytes.length - 4, rawBytes.length)));
                    tx2.setLocktime(locktime);
                } else {
                    tx2 = Tx.parse(new ByteArrayInputStream(rawBytes), testnet);
                }
                if (!tx2.id().equals(txId64)) {
                    throw new IllegalStateException(String.format("not the same id: %s vs %s", tx2.id(), txId));
                }
                cache.put(txId64, txRaw);
                TxFetcher.dumpCache(doFresh);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                throw new IllegalStateException(e.getMessage());
            }
            log.fine(String.format("time %sms", System.currentTimeMillis() - start));
        }
        if (!(computed = Boolean.TRUE.equals((tx = Tx.parse(txStream = new ByteArrayInputStream(txBytes = Bytes.hexStringToByteArray(cache.get(txId64))), testnet)).getSegwit()) ? tx.id() : Hex.parse(Bytes.changeOrder(Helper.hash256(txBytes))).toString()).equals(txId)) {
            throw new IllegalStateException(String.format("server lied: %s vs %s", computed, txId));
        }
        log.fine(String.format("tx %s", tx));
        return tx;
    }

    private static String getUrlBlockstream(Boolean testnet, String txId64) {
        String baseUrl = Boolean.TRUE.equals(testnet) ? Properties.getBlockstreamTestnetUrl() : Properties.getBlockstreamMainnetUrl();
        return String.format("%s/tx/%s/hex", baseUrl, txId64);
    }

    private static void loadCache(Boolean fresh) {
        if (Boolean.TRUE.equals(fresh)) {
            cache = new ConcurrentHashMap<String, String>();
            return;
        }
        try {
            File fileToReadObject = new File(CACHE_FILE);
            FileInputStream fileIn = new FileInputStream(fileToReadObject);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            cache = (Map)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    private static void dumpCache(Boolean fresh) {
        if (Boolean.TRUE.equals(fresh)) {
            return;
        }
        try {
            File fileToSaveObject = new File(CACHE_FILE);
            FileOutputStream fileOut = new FileOutputStream(fileToSaveObject);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(cache);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            log.severe(e.getMessage());
        }
    }
}

