/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.block;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MerkleTreeLevel {
    private List<byte[]> items;

    public MerkleTreeLevel(int numItems) {
        this.items = new ArrayList<Object>(Collections.nCopies(numItems, null));
    }

    public String toString() {
        return "{" + this.items.stream().map(item -> {
            if (item == null) {
                return null;
            }
            String shrt = String.format("%s...", Hex.parse(item).toString().substring(0, 8));
            if (this.items.size() == 1) {
                return String.format("*%s*", shrt.substring(0, shrt.length() - 2));
            }
            return shrt;
        }).collect(Collectors.joining(", ")) + "}";
    }

    public List<byte[]> getItems() {
        return this.items;
    }

    public void setItems(List<byte[]> items) {
        this.items = items;
    }
}

