/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Helper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class Bytes {
    private static final Logger log = Logger.getLogger(Bytes.class.getSimpleName());
    private static final byte[] HEX_ARRAY = "0123456789abcdef".getBytes();

    private Bytes() {
    }

    public static byte[] lstrip(byte[] bytes, byte bite) {
        int i = 0;
        while (bytes[i] == bite) {
            ++i;
        }
        return Arrays.copyOfRange(bytes, i, bytes.length);
    }

    public static byte[] strip(byte[] bytes, byte bite) {
        byte[] setyb = Bytes.changeOrder(bytes);
        int i = 0;
        while (setyb[i] == bite) {
            ++i;
        }
        return Arrays.copyOfRange(bytes, 0, bytes.length - i);
    }

    public static byte[] initFill(int length, byte filler) {
        byte[] init = new byte[length];
        Arrays.fill(init, filler);
        return init;
    }

    public static byte[] add(byte[] a, byte[] b) {
        byte[] z = new byte[a.length + b.length];
        System.arraycopy(a, 0, z, 0, a.length);
        System.arraycopy(b, 0, z, a.length, b.length);
        return z;
    }

    public static byte[] add(byte[][] bytesArray) {
        int lengthAdded = 0;
        for (byte[] bytes : bytesArray) {
            lengthAdded += bytes.length;
        }
        byte[] bytesAdded = new byte[lengthAdded];
        int destPos = 0;
        for (byte[] bytes : bytesArray) {
            System.arraycopy(bytes, 0, bytesAdded, destPos, bytes.length);
            destPos += bytes.length;
        }
        return bytesAdded;
    }

    public static byte[] changeOrder(byte[] bytes) {
        byte[] destBytes = Arrays.copyOf(bytes, bytes.length);
        int i = 0;
        for (int j = destBytes.length - 1; i < j; ++i, --j) {
            byte b = destBytes[i];
            destBytes[i] = destBytes[j];
            destBytes[j] = b;
        }
        return destBytes;
    }

    public static byte[] read(ByteArrayInputStream stream, int len) {
        try {
            return stream.readNBytes(len);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String byteArrayToString(byte[] bytes) {
        return new String(bytes);
    }

    public static Int bitsToTarget(byte[] bits) {
        int bitsLen = bits.length;
        Hex exponent = Hex.parse(Arrays.copyOfRange(bits, bitsLen - 1, bitsLen));
        Hex coefficient = Hex.parse(Bytes.changeOrder(Arrays.copyOfRange(bits, 0, bitsLen - 1)));
        return coefficient.mul(Int.parse(256).pow(exponent.sub(Int.parse(3))));
    }

    public static byte[] targetToBits(Int target) {
        byte[] coefficient;
        int exponent;
        byte[] rawBytes = target.toBytes(32);
        if (((rawBytes = Bytes.lstrip(rawBytes, (byte)0))[0] >> 8 & 1) == 1) {
            exponent = rawBytes.length + 1;
            coefficient = Bytes.add(new byte[]{0}, Arrays.copyOfRange(rawBytes, 0, 2));
        } else {
            exponent = rawBytes.length;
            coefficient = Arrays.copyOfRange(rawBytes, 0, 3);
        }
        return Bytes.add(Bytes.changeOrder(coefficient), new byte[]{(byte)exponent});
    }

    public static byte[] calculateNewBits(byte[] previousBits, Int timeDifferential) {
        Int newTarget;
        if (timeDifferential.gt(Helper.TWO_WEEKS.mul(Int.parse(4)))) {
            timeDifferential = Helper.TWO_WEEKS.mul(Int.parse(4));
        }
        if (timeDifferential.lt(Helper.TWO_WEEKS.div(Int.parse(4)))) {
            timeDifferential = Helper.TWO_WEEKS.div(Int.parse(4));
        }
        if ((newTarget = Bytes.bitsToTarget(previousBits).mul(timeDifferential).div(Helper.TWO_WEEKS)).gt(Helper.MAX_TARGET)) {
            newTarget = Helper.MAX_TARGET;
        }
        return Bytes.targetToBits(newTarget);
    }

    public static byte[] bitFieldToBytes(byte[] bitField) {
        if (bitField.length % 8 != 0) {
            throw new IllegalArgumentException("bit_field does not have a length that is divisible by 8");
        }
        byte[] result = new byte[bitField.length / 8];
        for (int i = 0; i < bitField.length; ++i) {
            int byteIndex = i / 8;
            int bitIndex = i % 8;
            if (bitField[i] != 1) continue;
            int n = byteIndex;
            result[n] = (byte)(result[n] | (byte)(1 << bitIndex));
        }
        return result;
    }

    public static byte[] bytesToBitField(byte[] someBytes) {
        ArrayList<Byte> flagBits = new ArrayList<Byte>();
        for (byte bite : someBytes) {
            for (int i = 0; i < 8; ++i) {
                flagBits.add((byte)(bite & 1));
                bite = (byte)(bite >> 1);
            }
        }
        byte[] bitField = new byte[flagBits.size()];
        for (int i = 0; i < flagBits.size(); ++i) {
            bitField[i] = (Byte)flagBits.get(i);
        }
        return bitField;
    }

    public static byte[] xor(byte[] b0, byte[] b1) {
        if (b0.length != b1.length) {
            return new byte[0];
        }
        byte[] ret = new byte[b0.length];
        int i = 0;
        for (byte b : b0) {
            ret[i] = (byte)(b ^ b1[i]);
            ++i;
        }
        return ret;
    }

    @Deprecated(since="0")
    public static byte[] log(byte[] bytes) {
        log.warning(String.format("%s (%s)", Bytes.byteArrayToHexString(bytes), bytes.length));
        return bytes;
    }
}

