/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Merkle {
    private static final Logger log = Logger.getLogger(Merkle.class.getSimpleName());

    private Merkle() {
    }

    public static byte[] merkleParent(byte[] hash0, byte[] hash1) {
        return Helper.hash256(Bytes.add(hash0, hash1));
    }

    public static List<byte[]> merkleParentLevel(List<byte[]> hashes) {
        if (hashes.size() <= 1) {
            String error = String.format("Cannot take a parent level with only %s item", hashes.size());
            log.severe(error);
            throw new IllegalArgumentException(error);
        }
        if (hashes.size() % 2 == 1) {
            hashes.add(hashes.get(hashes.size() - 1));
        }
        ArrayList<byte[]> parentLevel = new ArrayList<byte[]>();
        for (int i = 0; i < hashes.size(); i += 2) {
            byte[] parent = Merkle.merkleParent(hashes.get(i), hashes.get(i + 1));
            parentLevel.add(parent);
        }
        return parentLevel;
    }

    public static byte[] merkleRoot(List<byte[]> hashes) {
        List<byte[]> currentLevel = hashes;
        while (currentLevel.size() > 1) {
            currentLevel = Merkle.merkleParentLevel(currentLevel);
        }
        return currentLevel.get(0);
    }
}

