/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import java.io.FileInputStream;
import java.util.logging.Logger;

public class Properties {
    private static final Logger log = Logger.getLogger(Properties.class.getSimpleName());
    private static final String PATH = Thread.currentThread().getContextClassLoader().getResource("").getPath() + "bitcoinjavalib.properties";
    private static final java.util.Properties bitcoinjavalibProperties = new java.util.Properties();

    private Properties() {
    }

    private static String getProperty(String property) {
        Object[] objectArray;
        FileInputStream fileInputStream = new FileInputStream(PATH);
        try {
            if (bitcoinjavalibProperties.isEmpty()) {
                bitcoinjavalibProperties.load(fileInputStream);
                for (Object keyObject : bitcoinjavalibProperties.keySet().stream().sorted().toArray()) {
                    String key = (String)keyObject;
                    log.info(String.format("%s=%s", key, bitcoinjavalibProperties.getProperty(key)));
                }
            }
            objectArray = bitcoinjavalibProperties.getProperty(property);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                throw new IllegalStateException(e.getMessage());
            }
        }
        fileInputStream.close();
        return objectArray;
    }

    public static String getBitcoinP2pUrl() {
        return Properties.getProperty("bitcoin.p2p.url");
    }

    public static String getBitcoinP2pHost() {
        return Properties.getBitcoinP2pUrl().split(":")[0];
    }

    public static Integer getBitcoinP2pPort() {
        return Integer.parseInt(Properties.getBitcoinP2pUrl().split(":")[1]);
    }

    public static Boolean getBitcoinP2pTestnet() {
        return Boolean.parseBoolean(Properties.getProperty("bitcoin.p2p.testnet"));
    }

    public static String getBitcoinRpcUrl() {
        return Properties.getProperty("bitcoin.rpc.url");
    }

    public static Boolean getBitcoinRpcTestnet() {
        return Boolean.parseBoolean(Properties.getProperty("bitcoin.rpc.testnet"));
    }

    public static String getBitcoinRpcAuth() {
        String auth = Properties.getProperty("bitcoin.rpc.auth");
        if (auth != null && !auth.trim().isEmpty()) {
            return auth;
        }
        return null;
    }

    public static String getBlockstreamMainnetUrl() {
        return Properties.getProperty("blockstream.mainnet.url");
    }

    public static String getBlockstreamTestnetUrl() {
        return Properties.getProperty("blockstream.testnet.url");
    }

    public static Boolean getTxFresh() {
        return Boolean.parseBoolean(Properties.getProperty("tx.fresh"));
    }

    public static String getTxCachefile() {
        return Properties.getProperty("tx.cachefile");
    }
}

