/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.block.Block;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayInputStream;
import java.util.logging.Logger;

public class HeadersMessage
implements Message {
    private static final Logger log = Logger.getLogger(HeadersMessage.class.getSimpleName());
    public static final String COMMAND = "headers";
    private final Block[] blocks;

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public HeadersMessage(Block[] blocks) {
        this.blocks = blocks;
    }

    public static HeadersMessage parse(ByteArrayInputStream stream) {
        Int numHeaders = Varint.read(stream);
        Block[] blocks = new Block[numHeaders.intValue()];
        for (int i = 0; i < numHeaders.intValue(); ++i) {
            blocks[i] = Block.parse(stream);
            Int numTxs = Varint.read(stream);
            if (numTxs.intValue() == 0) continue;
            String error = "number of txs not 0";
            log.severe(error);
            throw new IllegalStateException(error);
        }
        return new HeadersMessage(blocks);
    }

    @Override
    public byte[] serialize() {
        return new byte[0];
    }

    public Block[] getBlocks() {
        return this.blocks;
    }
}

