/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.util;

import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bech32;

public class AddressUtil {
    private AddressUtil() {
    }

    public static boolean isInvoiceAddress(String address) {
        if (AddressUtil.isP2pkhAddress(address)) {
            return true;
        }
        if (AddressUtil.isP2shAddress(address)) {
            return true;
        }
        return AddressUtil.isBech32Address(address);
    }

    public static boolean isP2pkhAddress(String address) {
        if (AddressUtil.isNotInvoiceAddressLength(address)) {
            return false;
        }
        try {
            if (address.startsWith("1")) {
                Base58.decode(address);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isP2shAddress(String address) {
        if (AddressUtil.isNotInvoiceAddressLength(address)) {
            return false;
        }
        try {
            if (address.startsWith("3")) {
                Base58.decode(address);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isBech32Address(String address) {
        if (AddressUtil.isNotInvoiceAddressLength(address)) {
            return false;
        }
        try {
            if (address.startsWith("bc")) {
                Bech32.decodeSegwit(address);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static boolean isNotInvoiceAddressLength(String address) {
        if (address == null) {
            return true;
        }
        if (address.startsWith("1") || address.startsWith("3")) {
            if (address.length() < 26) {
                return true;
            }
            return address.length() > 35;
        }
        if (address.startsWith("bc")) {
            if (address.length() < 14) {
                return true;
            }
            return address.length() > 74;
        }
        return true;
    }
}

