/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import java.security.SecureRandom;
import java.util.logging.Logger;

public class Helper {
    private static final Logger log = Logger.getLogger(Helper.class.getSimpleName());

    private Helper() {
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    public static String zfill64(String bytes) {
        return String.format("%64s", bytes).replace(' ', '0');
    }

    public static String maskString(String str, int len) {
        return str.substring(0, len) + ":" + str.substring(str.length() - len);
    }

    public static String btcToSat(double f) {
        return String.format("%8.0f", f * 1.0E8).trim();
    }

    public static double logWithBase(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    @Deprecated(since="0")
    public static String log(String string) {
        log.warning(String.format("%s (%s) %s", string, string.length()));
        return string;
    }
}

