/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bech32;
import ch.bitagent.bitcoin.lib.helper.Bytes;

public class Address {
    private final String addressString;

    public Address(String address) {
        this.addressString = address;
    }

    public static Address parse(String address) {
        return new Address(address);
    }

    public boolean isInvoiceAddress() {
        if (this.isP2pkhAddress()) {
            return true;
        }
        if (this.isP2shAddress()) {
            return true;
        }
        return this.isBech32Address();
    }

    public boolean isP2pkhAddress() {
        if (this.isNotInvoiceAddressLength()) {
            return false;
        }
        try {
            if (this.addressString.startsWith("1")) {
                Base58.decodeAddress(this.addressString);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isP2shAddress() {
        if (this.isNotInvoiceAddressLength()) {
            return false;
        }
        try {
            if (this.addressString.startsWith("3")) {
                Base58.decodeAddress(this.addressString);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isBech32Address() {
        if (this.isNotInvoiceAddressLength()) {
            return false;
        }
        try {
            if (this.addressString.startsWith("bc")) {
                Bech32.decodeSegwit(this.addressString);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean isNotInvoiceAddressLength() {
        if (this.addressString == null) {
            return true;
        }
        if (this.addressString.startsWith("1") || this.addressString.startsWith("3")) {
            if (this.addressString.length() < 26) {
                return true;
            }
            return this.addressString.length() > 35;
        }
        if (this.addressString.startsWith("bc")) {
            if (this.addressString.length() < 14) {
                return true;
            }
            return this.addressString.length() > 74;
        }
        return true;
    }

    public String address() {
        return this.addressString;
    }

    public byte[] hash160() {
        if (this.isP2pkhAddress() || this.isP2shAddress()) {
            return Base58.decodeAddress(this.addressString);
        }
        if (this.isBech32Address()) {
            String scriptPubkey = Bech32.decodeSegwit(this.addressString);
            return Bytes.hexStringToByteArray(scriptPubkey.substring(4));
        }
        throw new IllegalStateException();
    }
}

