/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayInputStream;

public class PongMessage
implements Message {
    public static final String COMMAND = "pong";
    private final byte[] nonce;

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public PongMessage(byte[] nonce) {
        this.nonce = nonce;
    }

    public static PongMessage parse(ByteArrayInputStream stream) {
        byte[] nonce = Bytes.read(stream, 8);
        return new PongMessage(nonce);
    }

    @Override
    public byte[] serialize() {
        return this.nonce;
    }
}

