/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bech32;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.script.Script;

public class Address {
    public static final String P2PKH = "p2pkh";
    public static final String P2SH = "p2sh";
    public static final String BECH32 = "bech32";
    private final String addressString;
    private int change = -1;
    private int addressIndex = -1;
    private int historyCount = 0;
    private long balance = 0L;

    public Address(String address) {
        this.addressString = address;
    }

    public static Address parse(String address) {
        return new Address(address);
    }

    public boolean isInvoiceAddress() {
        if (this.isP2pkhAddress()) {
            return true;
        }
        if (this.isP2shAddress()) {
            return true;
        }
        return this.isBech32Address();
    }

    public boolean isP2pkhAddress() {
        if (this.isNotInvoiceAddressLength()) {
            return false;
        }
        try {
            if (this.addressString.startsWith("1")) {
                Base58.decodeAddress(this.addressString);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isP2shAddress() {
        if (this.isNotInvoiceAddressLength()) {
            return false;
        }
        try {
            if (this.addressString.startsWith("3")) {
                Base58.decodeAddress(this.addressString);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isBech32Address() {
        if (this.isNotInvoiceAddressLength()) {
            return false;
        }
        try {
            if (this.addressString.startsWith("bc")) {
                Bech32.decodeSegwit(this.addressString);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean isNotInvoiceAddressLength() {
        if (this.addressString == null) {
            return true;
        }
        if (this.addressString.startsWith("1") || this.addressString.startsWith("3")) {
            if (this.addressString.length() < 26) {
                return true;
            }
            return this.addressString.length() > 35;
        }
        if (this.addressString.startsWith("bc")) {
            if (this.addressString.length() < 14) {
                return true;
            }
            return this.addressString.length() > 74;
        }
        return true;
    }

    public byte[] hash160() {
        if (this.isP2pkhAddress() || this.isP2shAddress()) {
            return Base58.decodeAddress(this.addressString);
        }
        if (this.isBech32Address()) {
            String scriptPubkey = Bech32.decodeSegwit(this.addressString);
            return Bytes.hexStringToByteArray(scriptPubkey.substring(4));
        }
        throw new IllegalStateException();
    }

    public String electrumScripthash() {
        if (this.isP2pkhAddress()) {
            byte[] hash160 = Base58.decodeAddress(this.addressString);
            Script script = Script.p2pkhScriptPubkey(hash160);
            byte[] hash = Hash.sha256(Bytes.hexStringToByteArray(script.toHex()));
            return Bytes.byteArrayToHexString(Bytes.changeOrder(hash));
        }
        if (this.isP2shAddress()) {
            byte[] hash160 = Base58.decodeAddress(this.addressString);
            Script script = Script.p2shScriptPubkey(hash160);
            byte[] hash = Hash.sha256(Bytes.hexStringToByteArray(script.toHex()));
            return Bytes.byteArrayToHexString(Bytes.changeOrder(hash));
        }
        if (this.isBech32Address()) {
            String scriptPubkey = Bech32.decodeSegwit(this.addressString);
            byte[] hash = Hash.sha256(Bytes.hexStringToByteArray(scriptPubkey));
            return Bytes.byteArrayToHexString(Bytes.changeOrder(hash));
        }
        throw new IllegalStateException();
    }

    public String getAddressString() {
        return this.addressString;
    }

    public int getChange() {
        return this.change;
    }

    public void setChange(int change) {
        this.change = change;
    }

    public int getAddressIndex() {
        return this.addressIndex;
    }

    public void setAddressIndex(int addressIndex) {
        this.addressIndex = addressIndex;
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int historyCount) {
        this.historyCount = historyCount;
    }

    public long getBalance() {
        return this.balance;
    }

    public void setBalance(long balance) {
        this.balance = balance;
    }

    public String toString() {
        if (this.change >= 0 && this.addressIndex >= 0) {
            return String.format("/%s/%s/%s/%s/%s", this.change, this.addressIndex, this.addressString, this.historyCount, this.balance);
        }
        return this.addressString;
    }
}

