/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.helper.Properties;
import ch.bitagent.bitcoin.lib.helper.Tcp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Electrum {
    private static final Logger log = Logger.getLogger(Electrum.class.getSimpleName());
    private final List<String> sockets = new ArrayList<String>();

    public List<String> getSockets() {
        return this.sockets;
    }

    public String defaultSocket() {
        List<String> electrumRpcSockets = Properties.getElectrumRpcSockets();
        if (electrumRpcSockets.isEmpty()) {
            String error = "Please configure a default electrum rpc socket in bitcoinjavalib.properties";
            log.severe(error);
            throw new IllegalStateException(error);
        }
        String electrumRpcSocket = electrumRpcSockets.get(0);
        log.fine(electrumRpcSocket);
        this.sockets.clear();
        this.sockets.add(electrumRpcSocket);
        return electrumRpcSocket;
    }

    public void allSockets() {
        this.sockets.clear();
        for (String electrumRpcSocket : Properties.getElectrumRpcSockets()) {
            log.fine(electrumRpcSocket);
            this.sockets.add(electrumRpcSocket);
        }
    }

    public String callSocket(String socket, String jsonRequest) {
        long start = System.currentTimeMillis();
        try {
            if (socket == null) {
                socket = this.defaultSocket();
            }
            log.fine(String.format(">> %s", jsonRequest));
            String[] socketData = socket.split(":");
            if (socketData.length != 3) {
                throw new IllegalArgumentException("Invalid socket");
            }
            String host = socketData[0];
            int port = Integer.parseInt(socketData[1]);
            String protocol = socketData[2].toLowerCase();
            String jsonResponse = "tls".equals(protocol) ? Tcp.tlsSocket(host, port, jsonRequest) : ("ssl".equals(protocol) ? Tcp.sslSocket(host, port, jsonRequest) : Tcp.socket(host, port, jsonRequest));
            if (jsonResponse == null) {
                log.severe(String.format("jsonResponse == null\n%s %sms", socket, System.currentTimeMillis() - start));
                return null;
            }
            Object responseLog = jsonResponse.toString();
            if (((String)responseLog).length() > 80) {
                responseLog = ((String)responseLog).substring(0, 80) + " ...";
            }
            log.fine(String.format("<< %s", responseLog));
            log.info(String.format("%s %sms", socket, System.currentTimeMillis() - start));
            return jsonResponse;
        }
        catch (Exception e) {
            log.severe(String.format("%s\n%s %sms", e, socket, System.currentTimeMillis() - start));
            e.printStackTrace();
            return null;
        }
    }

    public List<JSONObject> ping() {
        ArrayList<JSONObject> pongs = new ArrayList<JSONObject>();
        String jsonRequest = "{\"jsonrpc\": \"2.0\", \"method\": \"server.ping\", \"params\": [], \"id\": \"bitcoinjavalib\"}";
        for (String socket : this.sockets) {
            String jsonResponse = this.callSocket(socket, jsonRequest);
            if (jsonResponse == null || jsonResponse.isEmpty()) continue;
            pongs.add(new JSONObject(jsonResponse));
        }
        return pongs;
    }

    public List<JSONObject> features() {
        ArrayList<JSONObject> features = new ArrayList<JSONObject>();
        String jsonRequest = "{\"jsonrpc\": \"2.0\", \"method\": \"server.features\", \"params\": [], \"id\": \"bitcoinjavalib\"}";
        for (String socket : this.sockets) {
            String jsonResponse = this.callSocket(socket, jsonRequest);
            JSONObject json = new JSONObject(jsonResponse);
            features.add(json.getJSONObject("result"));
        }
        return features;
    }

    public List<JSONArray> versions() {
        ArrayList<JSONArray> versions = new ArrayList<JSONArray>();
        String jsonRequest = "{\"jsonrpc\": \"2.0\", \"method\": \"server.version\", \"params\": [\"\", \"1.4\"], \"id\": \"bitcoinjavalib\"}";
        for (String socket : this.sockets) {
            String jsonResponse = this.callSocket(socket, jsonRequest);
            JSONObject json = new JSONObject(jsonResponse);
            versions.add(json.getJSONArray("result"));
        }
        return versions;
    }

    public JSONArray peers() {
        String jsonRequest = "{\"jsonrpc\": \"2.0\", \"method\": \"server.peers.subscribe\", \"params\": [], \"id\": \"bitcoinjavalib\"}";
        String jsonResponse = this.callSocket(null, jsonRequest);
        JSONObject json = new JSONObject(jsonResponse);
        return json.getJSONArray("result");
    }

    public JSONArray getHistory(String scripthash) {
        String jsonRequest = String.format("{\"jsonrpc\": \"2.0\", \"method\": \"blockchain.scripthash.get_history\", \"params\": [\"%s\"], \"id\": \"bitcoinjavalib\"}", scripthash);
        String jsonResponse = this.callSocket(null, jsonRequest);
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        return json.getJSONArray("result");
    }

    public JSONObject getBalance(String scripthash) {
        String jsonRequest = String.format("{\"jsonrpc\": \"2.0\", \"method\": \"blockchain.scripthash.get_balance\", \"params\": [\"%s\"], \"id\": \"bitcoinjavalib\"}", scripthash);
        String jsonResponse = this.callSocket(null, jsonRequest);
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        return json.getJSONObject("result");
    }

    public Long getBalanceTotal(String scripthash) {
        JSONObject balance = this.getBalance(scripthash);
        if (balance == null) {
            return null;
        }
        long unconfirmed = balance.getLong("unconfirmed");
        long confirmed = balance.getLong("confirmed");
        return unconfirmed + confirmed;
    }
}

