/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.ecc.PrivateKey;
import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.helper.Helper;
import ch.bitagent.bitcoin.lib.helper.Pbkdf2;
import ch.bitagent.bitcoin.lib.wallet.ExtendedKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import javax.crypto.Mac;

public class MnemonicSentence {
    private static final Logger log = Logger.getLogger(MnemonicSentence.class.getSimpleName());
    private static final String RESOURCE_ENGLISH = "/wallet/english.txt";
    private static final int PBKDF2_ROUNDS = 2048;
    private static final int DERIVED_KEY_LENGTH = 64;

    private MnemonicSentence() {
    }

    public static byte[] generateEntropy(int entropyStrength) {
        if (entropyStrength != 128 && entropyStrength != 160 && entropyStrength != 192 && entropyStrength != 224 && entropyStrength != 256) {
            throw new IllegalArgumentException("Invalid entropy strength. Allowed values are 128, 160, 192, 224 or 256 bits.");
        }
        int entropyLength = entropyStrength / 8;
        return Bytes.randomBytes(entropyLength);
    }

    public static String entropyToMnemonic(byte[] entropy) {
        if (entropy.length != 16 && entropy.length != 20 && entropy.length != 24 && entropy.length != 28 && entropy.length != 32) {
            throw new IllegalArgumentException(String.format("Entropy length should be one of the following: 16, 20, 24, 28 or 32, but it is not %s.", entropy.length));
        }
        String entropyBin = Hex.parse(entropy).toBin();
        String entropyBinZ = Helper.zfill(entropy.length * 8, entropyBin);
        String concatenatedBin = entropyBinZ + MnemonicSentence.createEntropyChecksum(entropy);
        ArrayList<String> wordlist = Helper.loadWordlist(RESOURCE_ENGLISH);
        ArrayList<String> mnemonicList = new ArrayList<String>();
        for (int i = 0; i < concatenatedBin.length() / 11; ++i) {
            String group11Bin = concatenatedBin.substring(i * 11, (i + 1) * 11);
            int wordIndex = Integer.parseInt(group11Bin, 2);
            mnemonicList.add(wordlist.get(wordIndex));
        }
        return String.join((CharSequence)" ", mnemonicList);
    }

    public static byte[] mnemonicToEntropy(String mnemonicSentence) {
        String[] mnemonicArray = MnemonicSentence.getMnemonicArray(mnemonicSentence);
        int concatenatedBinLength = mnemonicArray.length * 11;
        boolean[] concatenatedBin = new boolean[concatenatedBinLength];
        ArrayList<String> wordlist = Helper.loadWordlist(RESOURCE_ENGLISH);
        for (int i = 0; i < mnemonicArray.length; ++i) {
            int wordIndex = MnemonicSentence.getWordIndex(wordlist, mnemonicArray, i);
            for (int j = 0; j < 11; ++j) {
                concatenatedBin[i * 11 + j] = (wordIndex & 1 << 10 - j) != 0;
            }
        }
        int checksumBinLength = concatenatedBinLength / 33;
        int entropyBinLength = concatenatedBinLength - checksumBinLength;
        byte[] entropy = new byte[entropyBinLength / 8];
        for (int i = 0; i < entropy.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!concatenatedBin[i * 8 + j]) continue;
                int n = i;
                entropy[n] = (byte)(entropy[n] | (byte)(1 << 7 - j));
            }
        }
        boolean[] checksumBin = Arrays.copyOfRange(concatenatedBin, entropyBinLength, concatenatedBinLength);
        if (!MnemonicSentence.verifyEntropyChecksum(entropy, Helper.boolArrayToString(checksumBin))) {
            throw new IllegalArgumentException("Failed checksum.");
        }
        return entropy;
    }

    private static String createEntropyChecksum(byte[] entropy) {
        byte[] checksum = Hash.sha256(entropy);
        String checksumBin = Hex.parse(checksum).toBin();
        return Helper.zfill(256, checksumBin).substring(0, entropy.length * 8 / 32);
    }

    private static boolean verifyEntropyChecksum(byte[] entropy, String checksum) {
        String checksumCheck = MnemonicSentence.createEntropyChecksum(entropy);
        return checksumCheck.equals(checksum);
    }

    public static byte[] mnemonicToSeed(String mnemonicSentence, String passphrase) {
        CharSequence[] mnemonicArray = MnemonicSentence.getMnemonicArray(mnemonicSentence);
        ArrayList<String> wordlist = Helper.loadWordlist(RESOURCE_ENGLISH);
        for (int i = 0; i < mnemonicArray.length; ++i) {
            MnemonicSentence.getWordIndex(wordlist, (String[])mnemonicArray, i);
        }
        if (passphrase == null) {
            passphrase = "";
        }
        passphrase = "mnemonic" + (String)passphrase;
        return Pbkdf2.derive(String.join((CharSequence)" ", mnemonicArray), (String)passphrase, 2048, 64);
    }

    private static String[] getMnemonicArray(String mnemonicSentence) {
        String[] mnemonicArray = mnemonicSentence.split(" ");
        if (mnemonicArray.length != 12 && mnemonicArray.length != 15 && mnemonicArray.length != 18 && mnemonicArray.length != 21 && mnemonicArray.length != 24) {
            throw new IllegalArgumentException(String.format("Number of words must be one of the following: 12, 15, 18, 21 or 24, but it is not (%s).", mnemonicArray.length));
        }
        return mnemonicArray;
    }

    private static int getWordIndex(ArrayList<String> wordlist, String[] mnemonicArray, int i) {
        int wordIndex = Collections.binarySearch(wordlist, mnemonicArray[i]);
        if (wordIndex < 0) {
            throw new IllegalArgumentException(String.format("Unable to find '%s' in word list.", mnemonicArray[i]));
        }
        return wordIndex;
    }

    public static String seedToExtendedKey(byte[] seed, Int xkeyPrefix) {
        if (seed.length != 64) {
            log.warning(String.format("Provided seed should have length of %s, not %s.", 64, seed.length));
        }
        Mac bitcoinSeedMac = Hash.hmacS512Init("Bitcoin seed".getBytes());
        bitcoinSeedMac.update(seed);
        byte[] bitcoinSeed = bitcoinSeedMac.doFinal();
        byte[] xkey = xkeyPrefix.toBytes();
        xkey = Bytes.add(xkey, Bytes.initFill(9, (byte)0));
        xkey = Bytes.add(xkey, Arrays.copyOfRange(bitcoinSeed, 32, bitcoinSeed.length));
        byte[] masterKey = Bytes.add(new byte[]{0}, Arrays.copyOfRange(bitcoinSeed, 0, 32));
        if (ExtendedKey.isKeyPrivate(xkeyPrefix.toBytes())) {
            xkey = Bytes.add(xkey, masterKey);
        } else {
            byte[] neutralMasterKey = PrivateKey.parse(masterKey).getPoint().sec(true);
            xkey = Bytes.add(xkey, neutralMasterKey);
        }
        byte[] hashedXprv = Hash.hash256(xkey);
        xkey = Bytes.add(xkey, Arrays.copyOfRange(hashedXprv, 0, 4));
        return Base58.encode(xkey);
    }
}

