/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.ecc;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import java.io.ByteArrayInputStream;
import java.util.logging.Logger;

public class Signature {
    private static final Logger log = Logger.getLogger(Signature.class.getSimpleName());
    private final Int r;
    private final Int s;

    public Signature(Int r, Int s) {
        this.r = r;
        this.s = s;
    }

    public byte[] der() {
        byte[] rBin = this.getR().toBytes(32);
        log.fine(String.format("rBin %s", Bytes.byteArrayToHexString(rBin)));
        rBin = Bytes.lstrip(rBin, (byte)0);
        if ((rBin[0] & 0x80) != 0) {
            rBin = Bytes.add(new byte[]{0}, rBin);
        }
        byte[] rBytes = new byte[]{2, (byte)rBin.length};
        byte[] rResult = Bytes.add(rBytes, rBin);
        byte[] sBin = this.getS().toBytes(32);
        log.fine(String.format("sBin %s", Bytes.byteArrayToHexString(sBin)));
        sBin = Bytes.lstrip(sBin, (byte)0);
        if ((sBin[0] & 0x80) != 0) {
            sBin = Bytes.add(new byte[]{0}, sBin);
        }
        byte[] sBytes = new byte[]{2, (byte)sBin.length};
        byte[] sResult = Bytes.add(sBytes, sBin);
        byte[] der = Bytes.add(new byte[][]{{48}, {(byte)(rResult.length + sResult.length)}, rResult, sResult});
        log.fine(String.format("der %s", Bytes.byteArrayToHexString(der)));
        boolean derNok = false;
        Signature sig2 = Signature.parse(der);
        if (sig2.getR().ne(this.getR())) {
            derNok = true;
            log.severe(String.format("invalid der r %s %s", sig2.getR().toHex(), this.getR().toHex()));
        }
        if (sig2.getS().ne(this.getS())) {
            derNok = true;
            log.severe(String.format("invalid der s %s %s", sig2.getS().toHex(), this.getS().toHex()));
        }
        if (derNok) {
            log.severe(String.format("invalid der %s", Bytes.byteArrayToHexString(der)));
        } else {
            log.fine(String.format("valid der %s", Bytes.byteArrayToHexString(der)));
        }
        return der;
    }

    public static Signature parse(byte[] signatureBin) {
        ByteArrayInputStream signatureStream = new ByteArrayInputStream(signatureBin);
        Hex compound = Hex.parse(Bytes.read(signatureStream, 1));
        if (compound.ne(Hex.parse("30"))) {
            throw new IllegalArgumentException("Bad Signature Compound");
        }
        Hex length = Hex.parse(Bytes.read(signatureStream, 1));
        if (length.add(Int.parse(2)).ne(Int.parse(signatureBin.length))) {
            throw new IllegalArgumentException("Bad Signature Length");
        }
        Hex marker = Hex.parse(Bytes.read(signatureStream, 1));
        if (marker.ne(Hex.parse("02"))) {
            throw new IllegalArgumentException("Bad Signature Marker");
        }
        Hex rLength = Hex.parse(Bytes.read(signatureStream, 1));
        Hex r = Hex.parse(Bytes.read(signatureStream, rLength.intValue()));
        marker = Hex.parse(Bytes.read(signatureStream, 1));
        if (marker.ne(Hex.parse("02"))) {
            throw new IllegalArgumentException("Bad Signature Marker");
        }
        Hex sLength = Hex.parse(Bytes.read(signatureStream, 1));
        Hex s = Hex.parse(Bytes.read(signatureStream, sLength.intValue()));
        if (signatureBin.length != 6 + rLength.intValue() + sLength.intValue()) {
            throw new IllegalArgumentException("Signature too long");
        }
        return new Signature(r, s);
    }

    public String toString() {
        return String.format("Signature(0x%s,0x%s)", this.r.toString(), this.s.toString());
    }

    public Int getR() {
        return this.r;
    }

    public Int getS() {
        return this.s;
    }
}

