/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayOutputStream;
import java.util.Objects;

public class VersionMessage
implements Message {
    public static final String COMMAND = "version";
    private final Int version;
    private final Int services;
    private final Int timestamp;
    private final Int receiverServices;
    private final byte[] receiverIp;
    private final Int receiverPort;
    private final Int senderServices;
    private final byte[] senderIp;
    private final Int senderPort;
    private final byte[] nonce;
    private final String userAgent;
    private final Int latestBlock;
    private final Boolean relay;

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public VersionMessage() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public VersionMessage(Int version, Int services, Int timestamp, Int receiverServices, byte[] receiverIp, Int receiverPort, Int senderServices, byte[] senderIp, Int senderPort, byte[] nonce, String userAgent, Int latestBlock, Boolean relay) {
        this.version = Objects.requireNonNullElse(version, Int.parse(70015));
        this.services = Objects.requireNonNullElse(services, Int.parse(0));
        this.timestamp = Objects.requireNonNullElse(timestamp, Int.parse(String.valueOf(System.currentTimeMillis() / 1000L)));
        this.receiverServices = Objects.requireNonNullElse(receiverServices, Int.parse(0));
        this.receiverIp = Objects.requireNonNullElse(receiverIp, new byte[]{0, 0, 0, 0});
        this.receiverPort = Objects.requireNonNullElse(receiverPort, Int.parse(8333));
        this.senderServices = Objects.requireNonNullElse(senderServices, Int.parse(0));
        this.senderIp = Objects.requireNonNullElse(senderIp, new byte[]{0, 0, 0, 0});
        this.senderPort = Objects.requireNonNullElse(senderPort, Int.parse(8333));
        this.nonce = Objects.requireNonNullElse(nonce, Bytes.randomBytes(8));
        this.userAgent = Objects.requireNonNullElse(userAgent, "/bitcoinjavalib/");
        this.latestBlock = Objects.requireNonNullElse(latestBlock, Int.parse(0));
        this.relay = Objects.requireNonNullElse(relay, false);
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(this.version.toBytesLittleEndian(4));
        result.writeBytes(this.services.toBytesLittleEndian(8));
        result.writeBytes(this.timestamp.toBytesLittleEndian(8));
        result.writeBytes(this.receiverServices.toBytesLittleEndian(8));
        result.writeBytes(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        result.writeBytes(new byte[]{-1, -1});
        result.writeBytes(this.receiverIp);
        result.writeBytes(this.receiverPort.toBytes(2));
        result.writeBytes(this.senderServices.toBytesLittleEndian(8));
        result.writeBytes(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        result.writeBytes(new byte[]{-1, -1});
        result.writeBytes(this.senderIp);
        result.writeBytes(this.senderPort.toBytes(2));
        result.writeBytes(Bytes.changeOrder(this.nonce));
        result.writeBytes(Varint.encode(Int.parse(this.userAgent.length())));
        result.writeBytes(this.userAgent.getBytes());
        result.writeBytes(this.latestBlock.toBytesLittleEndian(4));
        if (Boolean.TRUE.equals(this.relay)) {
            result.writeBytes(new byte[]{1});
        } else {
            result.writeBytes(new byte[]{0});
        }
        return result.toByteArray();
    }
}

